/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.EARMGA;

import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.EARMGA.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.EARMGA.Chromosome;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.EARMGA.DataB;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.EARMGA.Gene;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.EARMGA.myDataset;
import org.core.Randomize;

public class EARMGAProcess {
    private myDataset ds;
    private DataB dataBase;
    ArrayList<Chromosome> pop;
    ArrayList<AssociationRule> assocRules;
    private int nTrials;
    private int trials;
    private int popsize;
    private double ps;
    private double pc;
    private double pm;
    private int kItemsets;
    private double alpha;

    public EARMGAProcess(myDataset ds, DataB dataBase, int nTrials, int popsize, int kItemsets, double ps, double pc, double pm, double alpha) {
        this.ds = ds;
        this.dataBase = dataBase;
        this.nTrials = nTrials;
        this.popsize = popsize;
        this.kItemsets = kItemsets;
        this.ps = ps;
        this.pc = pc;
        this.pm = pm;
        this.alpha = alpha;
    }

    public void run() {
        this.trials = 0;
        int nGen = 0;
        System.out.println("Initialization");
        this.initialize();
        do {
            System.out.println("Generation: " + nGen);
            this.select();
            ArrayList<Chromosome> pop_temp = this.crossover();
            for (int i = pop_temp.size() - 1; i >= 0; --i) {
                Chromosome chromo = pop_temp.get(i);
                if (Randomize.Rand() * chromo.getFit() < this.pm) {
                    this.mutate(chromo);
                    this.fitness(chromo);
                }
                if (!(chromo.getFit() <= 0.0)) continue;
                pop_temp.remove(i);
            }
            this.elitist(pop_temp);
            ++nGen;
        } while (!this.terminate());
        this.genRules();
    }

    public boolean terminate() {
        Collections.sort(this.pop);
        Chromosome best = this.pop.get(0);
        Chromosome worst = this.pop.get(this.pop.size() - 1);
        return this.trials > this.nTrials;
    }

    private void initialize() {
        int i;
        Chromosome chromo;
        this.pop = new ArrayList();
        int nVars = this.ds.getnVars();
        do {
            chromo = new Chromosome(Randomize.Randint(0, this.kItemsets - 1), nVars);
            for (i = 0; i < this.kItemsets; ++i) {
                Gene gen = new Gene();
                int attr = Randomize.Randint(0, nVars);
                while (chromo.isUsed(attr)) {
                    attr = (attr + 1) % nVars;
                }
                gen.setAttr(attr);
                gen.setType(this.ds.getType(attr));
                gen.addValue(Randomize.Randint(0, this.dataBase.numIntervals(attr)));
                chromo.add(gen);
            }
            this.fitness(chromo);
        } while (chromo.getFit() <= 0.0);
        this.pop.add(chromo);
        while ((double)this.pop.size() <= (double)this.popsize / 2.0) {
            int top = this.pop.size();
            for (i = 0; i < top; ++i) {
                chromo = this.pop.get(i).copy();
                this.mutate(chromo);
                this.fitness(chromo);
                if (!(chromo.getFit() > 0.0)) continue;
                this.pop.add(chromo);
            }
        }
    }

    private void select() {
        for (int i = this.pop.size() - 1; i >= 0; --i) {
            if (!(Randomize.Rand() * this.pop.get(i).getFit() > this.ps)) continue;
            this.pop.remove(i);
        }
    }

    private ArrayList<Chromosome> crossover() {
        ArrayList<Chromosome> pop_tmp = new ArrayList<Chromosome>();
        for (int i = 0; i < this.pop.size(); ++i) {
            Chromosome dad = this.pop.get(i);
            for (int j = i + 1; j < this.pop.size(); ++j) {
                int k;
                int posj;
                if (!(Randomize.Rand() < this.pc)) continue;
                Chromosome mom = this.pop.get(j);
                int posi = Randomize.Randint(0, this.kItemsets);
                if (posi > (posj = Randomize.Randint(0, this.kItemsets))) {
                    int aux = posi;
                    posi = posj;
                    posj = aux;
                }
                Chromosome off1 = dad.copy();
                Chromosome off2 = mom.copy();
                if (posi == 0) {
                    off1.setLengthAnt(mom.getLengthAnt());
                    off2.setLengthAnt(dad.getLengthAnt());
                }
                for (k = posi; k <= posj; ++k) {
                    off1.offUsed(off1.getGen(k).getAttr());
                    off2.offUsed(off2.getGen(k).getAttr());
                }
                for (k = posi; k <= posj; ++k) {
                    int pos = k;
                    if (off1.isUsed(mom.getGen(pos).getAttr())) {
                        pos = (posj + 1) % this.kItemsets;
                        while (off1.isUsed(mom.getGen(pos).getAttr())) {
                            pos = (pos + 1) % this.kItemsets;
                        }
                    }
                    off1.getGen(k).setAttr(mom.getGen(pos).getAttr());
                    off1.getGen(k).setType(mom.getGen(pos).getType());
                    off1.getGen(k).setValue(mom.getGen(pos).getValue());
                    off1.onUsed(off1.getGen(k).getAttr());
                    pos = k;
                    if (off2.isUsed(dad.getGen(pos).getAttr())) {
                        pos = (posj + 1) % this.kItemsets;
                        while (off2.isUsed(dad.getGen(pos).getAttr())) {
                            pos = (pos + 1) % this.kItemsets;
                        }
                    }
                    off2.getGen(k).setAttr(dad.getGen(pos).getAttr());
                    off2.getGen(k).setType(dad.getGen(pos).getType());
                    off2.getGen(k).setValue(dad.getGen(pos).getValue());
                    off2.onUsed(off2.getGen(k).getAttr());
                }
                this.fitness(off1);
                this.fitness(off2);
                pop_tmp.add(off1);
                pop_tmp.add(off2);
            }
        }
        return pop_tmp;
    }

    private void mutate(Chromosome chromo) {
        int i;
        chromo.setLengthAnt(Randomize.Randint(0, this.kItemsets - 1));
        Gene gen = chromo.getGen(Randomize.Randint(0, this.kItemsets));
        int attr_ant = gen.getAttr();
        double prop = (double)gen.numIntervals() / ((double)this.dataBase.numIntervals(attr_ant) * 1.0);
        int attr = Randomize.Randint(0, this.ds.getnVars());
        for (i = 0; chromo.isUsed(attr) && i < this.ds.getnVars(); ++i) {
            attr = (attr + 1) % this.ds.getnVars();
        }
        if (chromo.isUsed(attr)) {
            attr = attr_ant;
        } else {
            chromo.offUsed(attr_ant);
            chromo.onUsed(attr);
            gen.setAttr(attr);
            gen.setType(this.ds.getType(attr));
        }
        gen.clearValue();
        for (i = 0; i < this.dataBase.numIntervals(attr); ++i) {
            if (!(Randomize.Rand() <= prop)) continue;
            gen.addValue(i);
        }
        if (gen.numIntervals() == 0) {
            gen.addValue(Randomize.Randint(0, this.dataBase.numIntervals(attr)));
        }
    }

    private void fitness(Chromosome chromo) {
        double nTrans = this.ds.getnTrans();
        ++this.trials;
        ArrayList<Integer> ant = this.countSupport(chromo, 0, chromo.getLengthAnt());
        if (ant.size() == 0) {
            chromo.setFit(0.0);
            chromo.setSupportAnt(0.0);
            chromo.setSupportCon(0.0);
            chromo.setSupportAll(0.0);
        } else {
            ArrayList<Integer> con = this.countSupport(chromo, chromo.getLengthAnt() + 1, this.kItemsets - 1);
            if ((double)con.size() / nTrans >= 1.0) {
                chromo.setFit(1.0);
                chromo.setSupportAnt((double)ant.size() / nTrans);
                chromo.setSupportCon(1.0);
                chromo.setSupportAll(chromo.getSupportAnt());
            } else {
                ArrayList<Integer> all = this.countSupport(chromo, 0, this.kItemsets - 1);
                if (all.size() == 0) {
                    chromo.setFit(0.0);
                    chromo.setSupportAnt((double)ant.size() / nTrans);
                    chromo.setSupportCon((double)con.size() / nTrans);
                    chromo.setSupportAll(0.0);
                } else {
                    chromo.setSupportAnt((double)ant.size() / nTrans);
                    chromo.setSupportCon((double)con.size() / nTrans);
                    chromo.setSupportAll((double)all.size() / nTrans);
                    double fit = (chromo.getSupportAll() - chromo.getSupportAnt() * chromo.getSupportCon()) / (chromo.getSupportAnt() * (1.0 - chromo.getSupportCon()));
                    if (fit > 1.0) {
                        fit = 1.0;
                    }
                    chromo.setFit(fit);
                }
            }
        }
    }

    private void elitist(ArrayList<Chromosome> pop_temp) {
        for (int i = 0; i < pop_temp.size(); ++i) {
            Chromosome chromo1 = pop_temp.get(i);
            for (int j = 0; j < this.pop.size(); ++j) {
                Chromosome chromo2 = this.pop.get(j);
                if (chromo1.isSub(chromo2)) {
                    if (chromo1.getFit() > chromo2.getFit()) {
                        this.pop.remove(j);
                        --j;
                        continue;
                    }
                    pop_temp.remove(i);
                    j = this.pop.size();
                    --i;
                    continue;
                }
                if (!chromo2.isSub(chromo1)) continue;
                if (chromo2.getFit() >= chromo1.getFit()) {
                    pop_temp.remove(i);
                    j = this.pop.size();
                    --i;
                    continue;
                }
                this.pop.remove(j);
                --j;
            }
        }
        this.pop.addAll(pop_temp);
        Collections.sort(this.pop);
        while (this.pop.size() > this.popsize) {
            this.pop.remove(this.pop.size() - 1);
        }
        System.gc();
    }

    private ArrayList<Integer> countSupport(Chromosome chromo, int ini, int fin) {
        ArrayList<Integer> tid_list = new ArrayList<Integer>();
        double[][] trans = this.ds.getRealTransactions();
        int nTrans = this.ds.getnTrans();
        for (int t = 0; t < nTrans; ++t) {
            boolean ok = true;
            for (int i = ini; i <= fin && ok; ++i) {
                int attr = chromo.getGen(i).getAttr();
                ArrayList<Integer> value = chromo.getGen(i).getValue();
                ok = false;
                for (int j = 0; j < value.size() && !ok; ++j) {
                    if (!this.dataBase.isCovered(attr, value.get(j), trans[t][attr])) continue;
                    ok = true;
                }
            }
            if (!ok) continue;
            tid_list.add(t);
        }
        return tid_list;
    }

    public static double roundDouble(double number, int decimalPlace) {
        if (!Double.isInfinite(number) && !Double.isNaN(number)) {
            BigDecimal bd = new BigDecimal(number);
            bd = bd.setScale(decimalPlace, 0);
            double numberRound = bd.doubleValue();
            return numberRound;
        }
        return number;
    }

    public void printReport(double minConfidence, double minSupport) {
        double avg_yulesQ = 0.0;
        double avg_sup = 0.0;
        double avg_conf = 0.0;
        double avg_lift = 0.0;
        double avg_conv = 0.0;
        double avg_CF = 0.0;
        double avg_netConf = 0.0;
        int length = 0;
        int countRules = 0;
        for (int i = 0; i < this.assocRules.size(); ++i) {
            AssociationRule rule = this.assocRules.get(i);
            if (!(rule.getConfidence() >= minConfidence) || !(rule.getAll_support() >= minSupport)) continue;
            ++countRules;
            length += rule.getLengthRule();
            avg_sup += rule.getAll_support();
            avg_conf += rule.getConfidence();
            avg_lift += rule.getLift();
            avg_conv += rule.getConv();
            avg_CF += rule.getCF();
            avg_netConf += rule.getNetConf();
            avg_yulesQ += rule.getYulesQ();
        }
        System.out.println("Number of Frequent Itemsets generated: -");
        System.out.println("Number of Association Rules generated: " + countRules);
        if (countRules != 0) {
            System.out.println("Average SupportRules: " + EARMGAProcess.roundDouble(avg_sup / (double)countRules, 2));
            System.out.println("Average Confidence: " + EARMGAProcess.roundDouble(avg_conf / (double)countRules, 2));
            System.out.println("Average Lift: " + EARMGAProcess.roundDouble(avg_lift / (double)countRules, 2));
            System.out.println("Average Conviction: " + EARMGAProcess.roundDouble(avg_conv / (double)countRules, 2));
            System.out.println("Average Certain Factor: " + EARMGAProcess.roundDouble(avg_CF / (double)countRules, 2));
            System.out.println("Average Netconf: " + EARMGAProcess.roundDouble(avg_netConf / (double)countRules, 2));
            System.out.println("Average YulesQ: " + EARMGAProcess.roundDouble(avg_yulesQ / (double)countRules, 2));
            System.out.println("Average Length of the Rules generated: " + EARMGAProcess.roundDouble((double)length / (double)countRules, 2));
            System.out.println("Number of Covered Records(%): " + 100.0 * (double)this.numCoveredRecords(minSupport) / (double)this.ds.getnTrans());
        } else {
            System.out.println("Average Support: 0.0");
            System.out.println("Average Confidence: 0.0");
            System.out.println("Average Lift: 0.0");
            System.out.println("Average Conviction: 0.0");
            System.out.println("Average Certain Factor: 0.0");
            System.out.println("Average Netconf: 0.0");
            System.out.println("Average Antecedents Length: 0.0");
            System.out.println("Number of Covered Records (%): 0.0");
        }
    }

    public String printRules(ArrayList<AssociationRule> rules) {
        boolean stop = false;
        String rulesList = "";
        rulesList = rulesList + "Support\tantecedent_support\tconsequent_support\tConfidence\tLift\tConv\tCF\tNetConf\tYulesQ\tnAttributes\n";
        for (int i = 0; i < rules.size() && !stop; ++i) {
            int lenghtrule = rules.get(i).getAntecedent().size() + rules.get(i).getConsequent().size();
            rulesList = rulesList + "" + EARMGAProcess.roundDouble(rules.get(i).getAll_support(), 2) + "\t" + EARMGAProcess.roundDouble(rules.get(i).getSupport_Ant(), 2) + "\t" + EARMGAProcess.roundDouble(rules.get(i).getSupport_cons(), 2) + "\t" + EARMGAProcess.roundDouble(rules.get(i).getConfidence(), 2) + "\t" + EARMGAProcess.roundDouble(rules.get(i).getLift(), 2) + "\t" + EARMGAProcess.roundDouble(rules.get(i).getConv(), 2) + "\t" + EARMGAProcess.roundDouble(rules.get(i).getCF(), 2) + "\t" + EARMGAProcess.roundDouble(rules.get(i).getNetConf(), 2) + "\t" + EARMGAProcess.roundDouble(rules.get(i).getYulesQ(), 2) + "\t" + lenghtrule + "\n";
        }
        return rulesList;
    }

    public void saveReport(double minSupport, PrintWriter w) {
        double avg_yulesQ = 0.0;
        double avg_sup = 0.0;
        double avg_conf = 0.0;
        double avg_lift = 0.0;
        double avg_conv = 0.0;
        double avg_CF = 0.0;
        double avg_netConf = 0.0;
        int length = 0;
        int countRules = 0;
        for (int i = 0; i < this.assocRules.size(); ++i) {
            AssociationRule rule = this.assocRules.get(i);
            if (!(rule.getAll_support() >= minSupport)) continue;
            ++countRules;
            length += rule.getLengthRule();
            avg_sup += rule.getAll_support();
            avg_conf += rule.getConfidence();
            avg_lift += rule.getLift();
            avg_conv += rule.getConv();
            avg_CF += rule.getCF();
            avg_netConf += rule.getNetConf();
            avg_yulesQ += rule.getYulesQ();
        }
        w.println("\nNumber of Frequent Itemsets generated: -");
        System.out.println("Number of Frequent Itemsets generated: -");
        w.println("\nNumber of Association Rules generated: " + countRules);
        System.out.println("Number of Association Rules generated: " + countRules);
        if (countRules != 0) {
            w.println("Average Support: " + EARMGAProcess.roundDouble(avg_sup / (double)countRules, 2));
            System.out.println("Average SupportRules: " + EARMGAProcess.roundDouble(avg_sup / (double)countRules, 2));
            w.println("Average Confidence: " + EARMGAProcess.roundDouble(avg_conf / (double)countRules, 2));
            System.out.println("Average Confidence: " + EARMGAProcess.roundDouble(avg_conf / (double)countRules, 2));
            w.println("Average Lift: " + EARMGAProcess.roundDouble(avg_lift / (double)countRules, 2));
            System.out.println("Average Lift: " + EARMGAProcess.roundDouble(avg_lift / (double)countRules, 2));
            w.println("Average Conviction: " + EARMGAProcess.roundDouble(avg_conv / (double)countRules, 2));
            System.out.println("Average Conviction: " + EARMGAProcess.roundDouble(avg_conv / (double)countRules, 2));
            w.println("Average Certain Factor: " + EARMGAProcess.roundDouble(avg_CF / (double)countRules, 2));
            System.out.println("Average Certain Factor: " + EARMGAProcess.roundDouble(avg_CF / (double)countRules, 2));
            w.println("Average Netconf: " + EARMGAProcess.roundDouble(avg_netConf / (double)countRules, 2));
            System.out.println("Average Netconf: " + EARMGAProcess.roundDouble(avg_netConf / (double)countRules, 2));
            w.println("Average YulesQ: " + EARMGAProcess.roundDouble(avg_yulesQ / (double)countRules, 2));
            System.out.println("Average YulesQ: " + EARMGAProcess.roundDouble(avg_yulesQ / (double)countRules, 2));
            w.println("Average Antecedents Length: " + EARMGAProcess.roundDouble((double)length / (double)countRules, 2));
            System.out.println("Average Length of the Rules generated: " + EARMGAProcess.roundDouble((double)length / (double)countRules, 2));
            w.println("Number of Covered Records (%): " + EARMGAProcess.roundDouble(100.0 * (double)this.numCoveredRecords(minSupport) / (double)this.ds.getnTrans(), 2));
            System.out.println("Number of Covered Records(%): " + 100.0 * (double)this.numCoveredRecords(minSupport) / (double)this.ds.getnTrans());
        } else {
            w.println("Average Support: 0.0");
            System.out.println("Average Support: 0.0");
            w.println("Average Confidence: 0.0");
            System.out.println("Average Confidence: 0.0");
            w.println("Average Lift: 0.0");
            System.out.println("Average Lift: 0.0");
            w.println("Average Conviction: 0.0");
            System.out.println("Average Conviction: 0.0");
            w.println("Average Certain Factor: 0.0");
            System.out.println("Average Certain Factor: 0.0");
            w.println("Average Netconf: 0.0");
            System.out.println("Average Netconf: 0.0");
            w.println("Average Antecedents Length: 0.0");
            System.out.println("Average Antecedents Length: 0.0");
            w.println("Number of Covered Records (%): 0.0");
            System.out.println("Number of Covered Records (%): 0.0");
        }
    }

    public ArrayList<AssociationRule> getSetRules(double minSupport) {
        ArrayList<AssociationRule> selectRules = new ArrayList<AssociationRule>();
        for (int i = 0; i < this.assocRules.size(); ++i) {
            AssociationRule rule = this.assocRules.get(i);
            if (!(rule.getAll_support() >= minSupport)) continue;
            selectRules.add(rule.copy());
        }
        return selectRules;
    }

    private void genRules() {
        this.assocRules = new ArrayList();
        for (int i = 0; i < this.pop.size(); ++i) {
            int j;
            Chromosome chromo = this.pop.get(i);
            AssociationRule rule = new AssociationRule();
            for (j = 0; j <= chromo.getLengthAnt(); ++j) {
                rule.addAntecedent(chromo.getGen(j).copy());
            }
            for (j = chromo.getLengthAnt() + 1; j < this.kItemsets; ++j) {
                rule.addConsequent(chromo.getGen(j).copy());
            }
            double confidance = chromo.getSupportAll() / chromo.getSupportAnt();
            double lift = chromo.getSupportAnt() == 0.0 || chromo.getSupportCon() == 0.0 ? 1.0 : chromo.getSupportAll() / (chromo.getSupportAnt() * chromo.getSupportCon());
            double conv = chromo.getSupportCon() == 1.0 || chromo.getSupportAnt() == 0.0 ? 1.0 : chromo.getSupportAnt() * (1.0 - chromo.getSupportCon()) / (chromo.getSupportAnt() - chromo.getSupportAll());
            double netConf = chromo.getSupportAnt() == 0.0 || chromo.getSupportAnt() == 1.0 || Math.abs(chromo.getSupportAnt() * (1.0 - chromo.getSupportAnt())) <= 0.001 ? 0.0 : (chromo.getSupportAll() - chromo.getSupportAnt() * chromo.getSupportCon()) / (chromo.getSupportAnt() * (1.0 - chromo.getSupportAnt()));
            double numeratorYules = chromo.getSupportAll() * (1.0 - chromo.getSupportCon() - chromo.getSupportAnt() + chromo.getSupportAll()) - (chromo.getSupportAnt() - chromo.getSupportAll()) * (chromo.getSupportCon() - chromo.getSupportAll());
            double denominatorYules = chromo.getSupportAll() * (1.0 - chromo.getSupportCon() - chromo.getSupportAnt() + chromo.getSupportAll()) + (chromo.getSupportAnt() - chromo.getSupportAll()) * (chromo.getSupportCon() - chromo.getSupportAll());
            double yulesQ = chromo.getSupportAnt() == 0.0 || chromo.getSupportAnt() == 1.0 || chromo.getSupportCon() == 0.0 || chromo.getSupportCon() == 1.0 || Math.abs(denominatorYules) <= 0.001 ? 0.0 : numeratorYules / denominatorYules;
            double CF = 0.0;
            if (confidance > chromo.getSupportCon()) {
                CF = (confidance - chromo.getSupportCon()) / (1.0 - chromo.getSupportCon());
            } else if (confidance < chromo.getSupportCon()) {
                CF = (confidance - chromo.getSupportCon()) / chromo.getSupportCon();
            }
            rule.setSupport_Ant(chromo.getSupportAnt());
            rule.setSupport_cons(chromo.getSupportCon());
            rule.setAll_support(chromo.getSupportAll());
            rule.setConfidence(confidance);
            rule.setLift(lift);
            rule.setConv(conv);
            rule.setCF(CF);
            rule.setNetConf(netConf);
            rule.setYulesQ(yulesQ);
            this.assocRules.add(rule);
        }
    }

    private int numCoveredRecords(double minSupport) {
        int i;
        int nTrans = this.ds.getnTrans();
        boolean[] marked = new boolean[nTrans];
        for (i = 0; i < nTrans; ++i) {
            marked[i] = false;
        }
        for (i = 0; i < this.pop.size(); ++i) {
            Chromosome chromo = this.pop.get(i);
            if (!(chromo.getSupportAll() >= minSupport)) continue;
            ArrayList<Integer> tidCovered = this.countSupport(chromo, 0, this.kItemsets - 1);
            for (int j = 0; j < tidCovered.size(); ++j) {
                marked[tidCovered.get((int)j).intValue()] = true;
            }
        }
        int covered = 0;
        for (i = 0; i < nTrans; ++i) {
            if (!marked[i]) continue;
            ++covered;
        }
        return covered;
    }
}

