/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml.pull;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import javax.realtime.MemoryArea;
import javolution.io.Utf8ByteBufferReader;
import javolution.io.Utf8StreamReader;
import javolution.lang.Reusable;
import javolution.lang.Text;
import javolution.lang.TypeFormat;
import javolution.util.FastTable;
import javolution.xml.pull.AttributesImpl;
import javolution.xml.pull.CharSequenceImpl;
import javolution.xml.pull.Namespaces;
import javolution.xml.pull.XmlPullParser;
import javolution.xml.pull.XmlPullParserException;
import javolution.xml.sax.Attributes;

public final class XmlPullParserImpl
implements XmlPullParser,
Reusable {
    public String FEATURE_IGNORE_WHITESPACE = "http://javolution.org/xml/pull/ignore-whitespace";
    private static final int MERGED_TEXT = 16;
    private static final int READER_BUFFER_CAPACITY = 2048;
    private int _lineNumber;
    private int _columnOffset;
    private int _lineLength;
    private int _index;
    private boolean _ignoreWhitespace;
    private char[] _data = new char[4096];
    private int _length;
    private int _depth;
    private final Namespaces _namespaces = new Namespaces();
    private final AttributesImpl _attributes = new AttributesImpl();
    private final FastTable _elemStack = new FastTable();
    private final char[] _chars = new char[2048];
    private final Utf8StreamReader _inputStreamReader = new Utf8StreamReader(2048);
    private final Utf8ByteBufferReader _byteBufferReader = new Utf8ByteBufferReader();
    private int _charsRead;
    private CharSequenceImpl _elemLocalName;
    private CharSequenceImpl _elemNamespace;
    private CharSequenceImpl _elemQName;
    private CharSequenceImpl _elemPrefix;
    private CharSequenceImpl _attrQName;
    private CharSequenceImpl _attrPrefix;
    private CharSequenceImpl _attrValue;
    private final CharSequenceImpl _num = new CharSequenceImpl();
    private int _eventType = 1;
    private String _inputEncoding;
    private boolean _isEmpty;
    private Reader _reader;
    private int _escStart;
    private int _savedState;
    private int _start;
    private int _state = 16;
    private CharSequenceImpl _text;
    private CharSequenceImpl _mergedText;
    private boolean _hasNonWhitespace;
    private CharSequenceImpl[] _seqs = new CharSequenceImpl[256];
    private int _seqsIndex;
    private int _seqsCapacity;
    private static final int CHAR_DATA = 16;
    private static final int MARKUP = 32;
    private static final int STATE_COMMENT = 48;
    private static final int PI = 64;
    private static final int CDATA = 80;
    private static final int OPEN_TAG = 96;
    private static final int CLOSE_TAG = 112;
    private static final int ESCAPE = 144;
    private static final int READ_ELEM_NAME = 1;
    private static final int ELEM_NAME_READ = 2;
    private static final int READ_ATTR_NAME = 3;
    private static final int ATTR_NAME_READ = 4;
    private static final int EQUAL_READ = 5;
    private static final int READ_ATTR_VALUE_SIMPLE_QUOTE = 6;
    private static final int READ_ATTR_VALUE_DOUBLE_QUOTE = 7;
    private static final int EMPTY_TAG = 8;

    public void setInput(ByteBuffer byteBuffer) {
        if (this._reader != null) {
            throw new IllegalStateException("Parser not reset.");
        }
        this._byteBufferReader.setByteBuffer(byteBuffer);
        this._inputEncoding = "UTF-8";
        this.setInput(this._byteBufferReader);
    }

    public void setInput(InputStream inputStream) {
        if (this._reader != null) {
            throw new IllegalStateException("Parser not reset.");
        }
        this._inputStreamReader.setInputStream(inputStream);
        this._inputEncoding = "UTF-8";
        this.setInput(this._inputStreamReader);
    }

    public void setInput(InputStream inputStream, String string) throws XmlPullParserException {
        if (string == null || string.equals("utf-8") || string.equals("UTF-8")) {
            this.setInput(inputStream);
            return;
        }
        try {
            this._inputEncoding = string;
            this.setInput(new InputStreamReader(inputStream, string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XmlPullParserException(unsupportedEncodingException.getMessage());
        }
    }

    public void setInput(Reader reader) {
        if (this._reader != null) {
            throw new IllegalStateException("Parser not reset.");
        }
        this._reader = reader;
        this._eventType = 0;
    }

    public void defineEntityReplacementText(String string, String string2) throws XmlPullParserException {
    }

    public Attributes getSaxAttributes() {
        return this._attributes;
    }

    public int getAttributeCount() {
        if (this._eventType != 2) {
            return -1;
        }
        return this._attributes.getLength();
    }

    public CharSequence getAttributeName(int n) {
        return this._attributes.getLocalName(n);
    }

    public CharSequence getAttributeNamespace(int n) {
        return this._attributes.getURI(n);
    }

    public CharSequence getAttributePrefix(int n) {
        return this._attributes.getPrefix(n);
    }

    public String getAttributeType(int n) {
        return this._attributes.getType(n);
    }

    public CharSequence getAttributeValue(String string, String string2) {
        return string == null ? this._attributes.getValue("", string2) : this._attributes.getValue(string, string2);
    }

    public CharSequence getAttributeValue(int n) {
        return this._attributes.getValue(n);
    }

    public int getDepth() {
        return this._depth;
    }

    public int getEventType() throws XmlPullParserException {
        return this._eventType;
    }

    public String getInputEncoding() {
        return this._inputEncoding;
    }

    public int getLineNumber() {
        int n = this._columnOffset + this._index;
        return n != 0 ? this._lineNumber : this._lineNumber - 1;
    }

    public int getColumnNumber() {
        int n = this._columnOffset + this._index;
        return n != 0 ? n : this._lineLength;
    }

    public CharSequence getName() {
        return this._elemLocalName;
    }

    public CharSequence getNamespace() {
        return this._elemNamespace;
    }

    public CharSequence getPrefix() {
        return this._elemPrefix;
    }

    public CharSequence getQName() {
        return this._elemQName;
    }

    public CharSequence getNamespace(String string) {
        return this._namespaces.getNamespaceUri(string);
    }

    public int getNamespaceCount(int n) {
        return this._namespaces.getNamespaceCount(n);
    }

    public CharSequence getNamespacePrefix(int n) {
        return this._namespaces.getNamespacePrefix(n);
    }

    public CharSequence getNamespaceUri(int n) {
        return this._namespaces.getNamespaceUri(n);
    }

    public CharSequence getPositionDescription() {
        return Text.valueOf("line ").concat(Text.valueOf(this.getLineNumber())).concat(Text.valueOf(", column ")).concat(Text.valueOf(this.getColumnNumber()));
    }

    public CharSequence getText() {
        return this._text;
    }

    public char[] getTextCharacters(int[] nArray) {
        if (this._text != null) {
            nArray[0] = this._text.offset;
            nArray[1] = this._text.length;
            return this._text.data;
        }
        nArray[1] = -1;
        nArray[0] = -1;
        return null;
    }

    public boolean isAttributeDefault(int n) {
        return false;
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        return this._isEmpty;
    }

    public boolean isWhitespace() throws XmlPullParserException {
        if (this._eventType == 4 || this._eventType == 5) {
            return !this._hasNonWhitespace;
        }
        throw new IllegalStateException();
    }

    public int next() throws XmlPullParserException, IOException {
        block5: while (true) {
            switch (this.nextToken()) {
                case 4: 
                case 5: {
                    if (this._mergedText == null) {
                        this._mergedText = this._text;
                    } else {
                        this._mergedText.data = this._text.data;
                        this._mergedText.length += this._text.length;
                    }
                    this._start = this._length = this._text.offset + this._text.length;
                    continue block5;
                }
                case 8: 
                case 9: {
                    continue block5;
                }
                case 16: {
                    this._text = this._mergedText;
                    this._mergedText = null;
                    this._eventType = 4;
                    return 4;
                }
            }
            break;
        }
        return this._eventType;
    }

    public int nextTag() throws XmlPullParserException, IOException {
        int n = this.next();
        if (n == 4 && this.isWhitespace()) {
            n = this.next();
        }
        if (n != 2 && n != 3) {
            throw this.error("expected start or end tag");
        }
        return n;
    }

    public CharSequence nextText() throws XmlPullParserException, IOException {
        if (this.getEventType() != 2) {
            throw this.error("parser must be on START_TAG to read next text");
        }
        int n = this.next();
        if (n == 4) {
            CharSequence charSequence = this.getText();
            n = this.next();
            if (n != 3) {
                throw this.error("event TEXT must be immediately followed by END_TAG");
            }
            return charSequence;
        }
        if (n == 3) {
            return CharSequenceImpl.EMPTY;
        }
        throw this.error("parser must be on START_TAG or TEXT to read text");
    }

    public void setFeature(String string, boolean bl) throws XmlPullParserException {
        if (string.equals(this.FEATURE_IGNORE_WHITESPACE)) {
            this._ignoreWhitespace = bl;
        }
    }

    public boolean getFeature(String string) {
        if (string.equals(this.FEATURE_IGNORE_WHITESPACE)) {
            return this._ignoreWhitespace;
        }
        return false;
    }

    public void setProperty(String string, Object object) throws XmlPullParserException {
    }

    public Object getProperty(String string) {
        return null;
    }

    public void require(int n, String string, String string2) throws XmlPullParserException, IOException {
        if (n != this.getEventType() || string != null && !this.getNamespace().equals(string) || string2 != null && this.getName().equals(string2)) {
            throw this.error("Require " + TYPES[n] + " failed");
        }
    }

    public int nextToken() throws XmlPullParserException, IOException {
        switch (this._eventType) {
            case 0: {
                this._charsRead = this._reader.read(this._chars, 0, this._chars.length);
                break;
            }
            case 1: {
                throw this.error("End of document reached.");
            }
            case 2: {
                this._attributes.reset();
                if (this._isEmpty) {
                    this._isEmpty = false;
                    this._eventType = 3;
                    return 3;
                }
                this._elemPrefix = null;
                this._elemLocalName = null;
                this._elemNamespace = null;
                this._elemQName = null;
                break;
            }
            case 3: {
                --this._depth;
                this._start = this._length = this._elemQName.offset;
                while (this._seqs[--this._seqsIndex] != this._elemQName) {
                }
                this._elemPrefix = null;
                this._elemLocalName = null;
                this._elemNamespace = null;
                this._elemQName = null;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                this._text = null;
                this._hasNonWhitespace = false;
            }
        }
        block28: while (this._index < this._charsRead) {
            int n = this._chars[this._index];
            if (++this._index == this._charsRead) {
                this._columnOffset += this._index;
                this._index = 0;
                this._charsRead = this._reader.read(this._chars, 0, this._chars.length);
                while (this._length + this._charsRead >= this._data.length) {
                    this.increaseDataBuffer();
                }
            }
            if (n < 32) {
                if (n == 13) {
                    if (this._index < this._charsRead && this._chars[this._index] == '\n') continue;
                    n = 10;
                }
                if (n == 10) {
                    ++this._lineNumber;
                    this._lineLength = this._columnOffset + this._index;
                    this._columnOffset = -this._index;
                } else if (n != 9) {
                    throw this.error("Illegal XML character U+" + Integer.toHexString(n));
                }
            }
            this._data[this._length++] = n;
            if (n == 38 && this._state != 48 && this._state != 64 && this._state != 80 && this._state != 144) {
                this._savedState = this._state;
                this._escStart = this._length;
                this._state = 144;
            }
            switch (this._state) {
                case 16: {
                    int n2;
                    if (n == 60) {
                        this._state = 32;
                        n2 = this._length - this._start - 1;
                        this._length = this._start;
                        if (!this._hasNonWhitespace && (this._ignoreWhitespace || n2 <= 0)) continue block28;
                        this.setText(this._start, n2);
                        this._eventType = 4;
                        return 4;
                    }
                    if (this._hasNonWhitespace || n <= 32) continue block28;
                    this._hasNonWhitespace = true;
                    break;
                }
                case 32: {
                    if (this._length - this._start == 1) {
                        if (n == 47) {
                            this._state = 113;
                            this._length = this._start;
                            this._elemQName = this.newSeq();
                            this._elemQName.offset = this._start;
                            if (this._mergedText == null) continue block28;
                            this._eventType = 16;
                            return 16;
                        }
                        if (n == 63) {
                            this._state = 64;
                            this._length = this._start;
                            break;
                        }
                        if (n == 33) continue block28;
                        this._state = 97;
                        this._elemQName = this.newSeq();
                        this._elemQName.offset = this._start;
                        if (this._mergedText == null) continue block28;
                        this._eventType = 16;
                        return 16;
                    }
                    if (this._length - this._start == 3 && this._data[this._start] == '!' && this._data[this._start + 1] == '-' && this._data[this._start + 2] == '-') {
                        this._state = 48;
                        this._length = this._start;
                        break;
                    }
                    if (this._length - this._start == 8 && this._data[this._start] == '!' && this._data[this._start + 1] == '[' && this._data[this._start + 2] == 'C' && this._data[this._start + 3] == 'D' && this._data[this._start + 4] == 'A' && this._data[this._start + 5] == 'T' && this._data[this._start + 6] == 'A' && this._data[this._start + 7] == '[') {
                        this._state = 80;
                        this._length = this._start;
                        break;
                    }
                    if (n != 62) continue block28;
                    this._state = 16;
                    this._length = this._start;
                    break;
                }
                case 48: {
                    if (n != 62 || this._length - this._start < 3 || this._data[this._length - 2] != '-' || this._data[this._length - 3] != '-') continue block28;
                    this._state = 16;
                    int n2 = this._length - this._start - 3;
                    this._length = this._start;
                    if (n2 <= 0) continue block28;
                    this.setText(this._start, n2);
                    this._eventType = 9;
                    return 9;
                }
                case 64: {
                    if (n != 62 || this._length - this._start < 2 || this._data[this._length - 2] != '?') continue block28;
                    this._state = 16;
                    int n2 = this._length - this._start - 2;
                    this._length = this._start;
                    if (n2 <= 0) continue block28;
                    this.setText(this._start, n2);
                    this._eventType = 8;
                    return 8;
                }
                case 80: {
                    int n2;
                    if (n == 62 && this._length - this._start >= 3 && this._data[this._length - 2] == ']' && this._data[this._length - 3] == ']') {
                        this._state = 16;
                        n2 = this._length - this._start - 3;
                        this._length = this._start;
                        if (n2 > 0) {
                            this.setText(this._start, n2);
                            this._eventType = 5;
                            return 5;
                        }
                    }
                    if (this._hasNonWhitespace || n <= 32) continue block28;
                    this._hasNonWhitespace = true;
                    break;
                }
                case 97: {
                    if (n == 62) {
                        this._elemQName.length = this._length - this._elemQName.offset - 1;
                        this._elemQName.data = this._data;
                        this._state = 16;
                        this._start = this._length;
                        this._eventType = this.processElement(96);
                        return this._eventType;
                    }
                    if (n == 47) {
                        this._elemQName.length = this._length - this._elemQName.offset - 1;
                        this._elemQName.data = this._data;
                        this._state = 104;
                        break;
                    }
                    if (n == 58 && this._elemPrefix == null) {
                        this._elemPrefix = this.newSeq();
                        this._elemPrefix.offset = this._elemQName.offset;
                        this._elemPrefix.length = this._length - this._elemQName.offset - 1;
                        this._elemPrefix.data = this._data;
                        break;
                    }
                    if (n > 32) continue block28;
                    this._elemQName.length = this._length - this._elemQName.offset - 1;
                    this._elemQName.data = this._data;
                    this._state = 98;
                    break;
                }
                case 98: {
                    if (n == 62) {
                        this._state = 16;
                        this._start = this._length;
                        this._eventType = this.processElement(96);
                        return this._eventType;
                    }
                    if (n == 47) {
                        this._state = 104;
                        break;
                    }
                    if (n <= 32) continue block28;
                    this._attrQName = this.newSeq();
                    this._attrQName.offset = this._length - 1;
                    this._state = 99;
                    break;
                }
                case 99: {
                    if (n <= 32) {
                        this._attrQName.length = this._length - this._attrQName.offset - 1;
                        this._attrQName.data = this._data;
                        this._state = 100;
                        break;
                    }
                    if (n == 61) {
                        this._attrQName.length = this._length - this._attrQName.offset - 1;
                        this._attrQName.data = this._data;
                        this._state = 101;
                        break;
                    }
                    if (n != 58 || this._attrPrefix != null) continue block28;
                    this._attrPrefix = this.newSeq();
                    this._attrPrefix.offset = this._attrQName.offset;
                    this._attrPrefix.length = this._length - this._attrQName.offset - 1;
                    this._attrPrefix.data = this._data;
                    break;
                }
                case 100: {
                    if (n == 61) {
                        this._state = 101;
                        break;
                    }
                    if (n <= 32) continue block28;
                    throw this.error("'=' expected");
                }
                case 101: {
                    if (n == 39) {
                        this._attrValue = this.newSeq();
                        this._attrValue.offset = this._length;
                        this._state = 102;
                        break;
                    }
                    if (n == 34) {
                        this._attrValue = this.newSeq();
                        this._attrValue.offset = this._length;
                        this._state = 103;
                        break;
                    }
                    if (n <= 32) continue block28;
                    throw this.error("Quotes expected");
                }
                case 102: {
                    if (n != 39) continue block28;
                    this._attrValue.length = this._length - this._attrValue.offset - 1;
                    this._attrValue.data = this._data;
                    this.processAttribute();
                    this._state = 98;
                    break;
                }
                case 103: {
                    if (n != 34) continue block28;
                    this._attrValue.length = this._length - this._attrValue.offset - 1;
                    this._attrValue.data = this._data;
                    this.processAttribute();
                    this._state = 98;
                    break;
                }
                case 104: {
                    if (n == 62) {
                        this._state = 16;
                        this._start = this._length;
                        this._eventType = this.processElement(104);
                        return this._eventType;
                    }
                    throw this.error("'>' expected");
                }
                case 113: {
                    if (n == 62) {
                        this._elemQName.length = this._length - this._elemQName.offset - 1;
                        this._elemQName.data = this._data;
                        this._state = 16;
                        this._start = this._length;
                        this._eventType = this.processElement(112);
                        return this._eventType;
                    }
                    if (n == 58 && this._elemPrefix == null) {
                        this._elemPrefix = this.newSeq();
                        this._elemPrefix.offset = this._elemQName.offset;
                        this._elemPrefix.length = this._length - this._elemQName.offset - 1;
                        this._elemPrefix.data = this._data;
                        break;
                    }
                    if (n > 32) continue block28;
                    this._elemQName.length = this._length - this._elemQName.offset - 1;
                    this._elemQName.data = this._data;
                    this._state = 114;
                    break;
                }
                case 114: {
                    if (n == 62) {
                        this._state = 16;
                        this._start = this._length;
                        this._eventType = this.processElement(112);
                        return this._eventType;
                    }
                    if (n <= 32) continue block28;
                    throw this.error("'>' expected");
                }
                case 144: {
                    if (n == 59) {
                        if (this._length - this._escStart == 3 && this._data[this._length - 3] == 'l' && this._data[this._length - 2] == 't') {
                            this._data[this._escStart - 1] = 60;
                        } else if (this._length - this._escStart == 3 && this._data[this._length - 3] == 'g' && this._data[this._length - 2] == 't') {
                            this._data[this._escStart - 1] = 62;
                        } else if (this._length - this._escStart == 5 && this._data[this._length - 5] == 'a' && this._data[this._length - 4] == 'p' && this._data[this._length - 3] == 'o' && this._data[this._length - 2] == 's') {
                            this._data[this._escStart - 1] = 39;
                        } else if (this._length - this._escStart == 5 && this._data[this._length - 5] == 'q' && this._data[this._length - 4] == 'u' && this._data[this._length - 3] == 'o' && this._data[this._length - 2] == 't') {
                            this._data[this._escStart - 1] = 34;
                        } else if (this._length - this._escStart == 4 && this._data[this._length - 4] == 'a' && this._data[this._length - 3] == 'm' && this._data[this._length - 2] == 'p') {
                            this._data[this._escStart - 1] = 38;
                        } else if (this._length - this._escStart > 1 && this._data[this._escStart] == '#') {
                            try {
                                if (this._data[this._escStart + 1] == 'x') {
                                    this._num.offset = this._escStart + 2;
                                    this._num.length = this._length - this._escStart - 3;
                                    this._num.data = this._data;
                                    this._data[this._escStart - 1] = (char)TypeFormat.parseInt(this._num, 16);
                                }
                                this._num.offset = this._escStart + 1;
                                this._num.length = this._length - this._escStart - 2;
                                this._num.data = this._data;
                                this._data[this._escStart - 1] = (char)TypeFormat.parseInt(this._num);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw this.error("Ill-formed character reference");
                            }
                        } else {
                            throw this.error("'#' expected");
                        }
                        this._state = this._savedState;
                        this._length = this._escStart;
                        break;
                    }
                    if (n > 32) continue block28;
                    throw this.error("';' expected");
                }
                default: {
                    throw this.error("State unknown: " + this._state);
                }
            }
        }
        if (this._depth != 0) {
            throw this.error("Unexpected end of file");
        }
        this.reset();
        return 1;
    }

    private void processAttribute() throws XmlPullParserException {
        if (this._attrPrefix == null) {
            if (XmlPullParserImpl.isXmlns(this._attrQName)) {
                this._namespaces.map(null, this._attrValue);
            } else {
                this._attributes.addAttribute(CharSequenceImpl.EMPTY, this._attrQName, CharSequenceImpl.EMPTY, this._attrQName, this._attrValue);
            }
        } else {
            CharSequenceImpl charSequenceImpl = this.newSeq();
            charSequenceImpl.offset = this._attrQName.offset + this._attrPrefix.length + 1;
            charSequenceImpl.length = this._attrQName.length - this._attrPrefix.length - 1;
            charSequenceImpl.data = this._attrQName.data;
            if (XmlPullParserImpl.isXmlns(this._attrPrefix)) {
                this._namespaces.map(charSequenceImpl, this._attrValue);
            } else {
                CharSequenceImpl charSequenceImpl2 = this._namespaces.getNamespaceUri(this._attrPrefix);
                if (charSequenceImpl2 != null) {
                    this._attributes.addAttribute(charSequenceImpl2, charSequenceImpl, this._attrPrefix, this._attrQName, this._attrValue);
                } else {
                    this.error("Namespace " + this._attrPrefix + " undefined");
                }
            }
            this._attrPrefix = null;
        }
    }

    private int processElement(int n) throws XmlPullParserException {
        if (this._elemPrefix != null) {
            this._elemLocalName = this.newSeq();
            this._elemLocalName.offset = this._elemQName.offset + this._elemPrefix.length + 1;
            this._elemLocalName.length = this._elemQName.length - this._elemPrefix.length - 1;
            this._elemLocalName.data = this._elemQName.data;
            this._elemNamespace = this._namespaces.getNamespaceUri(this._elemPrefix);
            if (this._elemNamespace == null) {
                throw this.error("Namespace " + this._elemPrefix + " undefined");
            }
        } else {
            this._elemLocalName = this._elemQName;
            this._elemNamespace = this._namespaces.getDefault();
        }
        if (n == 104) {
            this._isEmpty = true;
            ++this._depth;
            this._namespaces.flush();
            return 2;
        }
        if (n == 96) {
            ++this._depth;
            this._elemStack.addLast(this._elemQName);
            this._elemStack.addLast(this._elemNamespace);
            this._elemStack.addLast(this._elemLocalName);
            this._elemStack.addLast(this._elemPrefix);
            this._namespaces.push();
            return 2;
        }
        if (n == 112) {
            this._elemPrefix = (CharSequenceImpl)this._elemStack.removeLast();
            this._elemLocalName = (CharSequenceImpl)this._elemStack.removeLast();
            this._elemNamespace = (CharSequenceImpl)this._elemStack.removeLast();
            CharSequenceImpl charSequenceImpl = this._elemQName;
            this._elemQName = (CharSequenceImpl)this._elemStack.removeLast();
            if (!this._elemQName.equals(charSequenceImpl)) {
                throw this.error("Unexpected end tag for " + this._elemQName);
            }
            this._namespaces.pop();
            return 3;
        }
        throw this.error("Unexpected state: " + n);
    }

    public void reset() {
        try {
            if (this._reader != null) {
                this._reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._attributes.reset();
        this._attrPrefix = null;
        this._attrQName = null;
        this._attrValue = null;
        this._attrQName = null;
        this._charsRead = 0;
        this._columnOffset = 0;
        this._depth = 0;
        this._elemLocalName = null;
        this._elemNamespace = null;
        this._elemPrefix = null;
        this._elemQName = null;
        this._elemStack.reset();
        this._escStart = 0;
        this._eventType = 1;
        this._hasNonWhitespace = false;
        this._ignoreWhitespace = false;
        this._index = 0;
        this._inputEncoding = null;
        this._isEmpty = false;
        this._length = 0;
        this._lineLength = 0;
        this._lineNumber = 0;
        this._mergedText = null;
        this._namespaces.reset();
        this._reader = null;
        this._savedState = 0;
        this._seqsIndex = 0;
        this._start = 0;
        this._state = 16;
        this._text = null;
    }

    private void setText(int n, int n2) {
        this._text = this.newSeq();
        this._text.data = this._data;
        this._text.offset = n;
        this._text.length = n2;
    }

    private static boolean isXmlns(CharSequenceImpl charSequenceImpl) {
        return charSequenceImpl.length == 5 && charSequenceImpl.data[charSequenceImpl.offset] == 'x' && charSequenceImpl.data[charSequenceImpl.offset + 1] == 'm' && charSequenceImpl.data[charSequenceImpl.offset + 2] == 'l' && charSequenceImpl.data[charSequenceImpl.offset + 3] == 'n' && charSequenceImpl.data[charSequenceImpl.offset + 4] == 's';
    }

    private XmlPullParserException error(String string) {
        XmlPullParserException xmlPullParserException = new XmlPullParserException(string, this, null);
        return xmlPullParserException;
    }

    private CharSequenceImpl newSeq() {
        return this._seqsIndex < this._seqsCapacity ? this._seqs[this._seqsIndex++] : this.newSeq2();
    }

    private CharSequenceImpl newSeq2() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                if (XmlPullParserImpl.this._seqsCapacity++ >= XmlPullParserImpl.this._seqs.length) {
                    CharSequenceImpl[] charSequenceImplArray = new CharSequenceImpl[XmlPullParserImpl.this._seqs.length * 2];
                    System.arraycopy(XmlPullParserImpl.this._seqs, 0, charSequenceImplArray, 0, XmlPullParserImpl.this._seqs.length);
                    XmlPullParserImpl.access$102(XmlPullParserImpl.this, charSequenceImplArray);
                }
                ((XmlPullParserImpl)XmlPullParserImpl.this)._seqs[((XmlPullParserImpl)XmlPullParserImpl.this)._seqsIndex] = new CharSequenceImpl();
            }
        });
        return this._seqs[this._seqsIndex++];
    }

    private void increaseDataBuffer() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                char[] cArray = new char[XmlPullParserImpl.this._data.length * 2];
                System.arraycopy(XmlPullParserImpl.this._data, 0, cArray, 0, XmlPullParserImpl.this._data.length);
                XmlPullParserImpl.access$302(XmlPullParserImpl.this, cArray);
            }
        });
    }

    static /* synthetic */ CharSequenceImpl[] access$102(XmlPullParserImpl xmlPullParserImpl, CharSequenceImpl[] charSequenceImplArray) {
        xmlPullParserImpl._seqs = charSequenceImplArray;
        return charSequenceImplArray;
    }

    static /* synthetic */ char[] access$302(XmlPullParserImpl xmlPullParserImpl, char[] cArray) {
        xmlPullParserImpl._data = cArray;
        return cArray;
    }
}

