/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.DT_GA;

import java.util.ArrayList;
import java.util.StringTokenizer;
import keel.Algorithms.Decision_Trees.DT_GA.Selector;
import keel.Algorithms.Decision_Trees.DT_GA.myDataset;

public class Regla {
    ArrayList<Selector> antecedente = new ArrayList();
    String clase;
    myDataset train;
    int[] ejemplosCubiertos;
    int[] ejemplosBienCubiertos;
    int nCubiertos;
    int nCubiertosOK;
    double fitness;
    int codigoRegla;

    public Regla() {
        this.ejemplosCubiertos = new int[1];
    }

    public Regla(String clase, myDataset train) {
        this.train = train;
        this.clase = clase;
        this.ejemplosCubiertos = new int[train.size()];
        this.ejemplosBienCubiertos = new int[train.size()];
    }

    public Regla(myDataset train, String linea) {
        this.train = train;
        this.ejemplosCubiertos = new int[train.size()];
        this.ejemplosBienCubiertos = new int[train.size()];
        String[] nombres = train.nombres();
        StringTokenizer campo = new StringTokenizer(linea, " ");
        campo.nextToken();
        String aux = campo.nextToken();
        while (!aux.equalsIgnoreCase("THEN")) {
            String atributo = campo.nextToken();
            String operador = campo.nextToken();
            String valor = campo.nextToken();
            Selector s = new Selector(atributo, operador, valor);
            s.adjuntaNombres(nombres);
            this.antecedente.add(s);
            aux = campo.nextToken();
        }
        campo.nextToken();
        campo.nextToken();
        this.clase = campo.nextToken();
    }

    public void incluyeSelector(Selector s) {
        this.antecedente.add(s);
    }

    public String printString() {
        String cadena = new String("");
        cadena = cadena + "IF ";
        for (int i = 0; i < this.antecedente.size() - 1; ++i) {
            cadena = cadena + this.antecedente.get(i).printString() + "AND ";
        }
        cadena = cadena + this.antecedente.get(this.antecedente.size() - 1).printString();
        cadena = cadena + " THEN Class = " + this.clase + " (" + this.nCubiertosOK + "/" + this.nCubiertos + ")\n";
        return cadena;
    }

    public Regla copia() {
        Regla r = new Regla(this.clase, this.train);
        r.antecedente = new ArrayList();
        for (int i = 0; i < this.antecedente.size(); ++i) {
            r.antecedente.add(this.antecedente.get(i).copia());
        }
        r.nCubiertos = this.nCubiertos;
        r.nCubiertosOK = this.nCubiertosOK;
        r.ejemplosCubiertos = new int[this.ejemplosCubiertos.length];
        r.ejemplosCubiertos = (int[])this.ejemplosCubiertos.clone();
        r.ejemplosBienCubiertos = new int[this.ejemplosBienCubiertos.length];
        r.ejemplosBienCubiertos = (int[])this.ejemplosBienCubiertos.clone();
        r.fitness = this.fitness;
        r.codigoRegla = this.codigoRegla;
        return r;
    }

    public int cubiertos() {
        return this.nCubiertos;
    }

    public int cubiertosOK() {
        return this.nCubiertosOK;
    }

    public void cubrirEjemplos() {
        this.nCubiertosOK = 0;
        this.nCubiertos = 0;
        for (int i = 0; i < this.train.size(); ++i) {
            double[] ejemplo = this.train.getExample(i);
            if (!this.cubre(ejemplo)) continue;
            this.ejemplosCubiertos[this.nCubiertos] = i;
            ++this.nCubiertos;
            if (this.train.getOutputAsString(i).compareToIgnoreCase(this.clase) != 0) continue;
            this.ejemplosBienCubiertos[this.nCubiertosOK] = i;
            ++this.nCubiertosOK;
        }
    }

    public boolean cubre(double[] ejemplo) {
        boolean cubierto = true;
        for (int i = 0; i < this.antecedente.size() && cubierto; ++i) {
            cubierto = cubierto && this.antecedente.get(i).cubre(ejemplo);
        }
        return cubierto;
    }

    public int size() {
        return this.antecedente.size();
    }

    public boolean contieneAtributo(int att) {
        boolean contiene = false;
        for (int i = 0; i < this.antecedente.size() && !contiene; ++i) {
            contiene = this.antecedente.get((int)i).atributo == att;
        }
        return contiene;
    }
}

