/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA;

import java.util.ArrayList;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.Item;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.myDataset;

public class Itemset {
    ArrayList<Item> itemset;
    int clas;
    double support;
    double supportRule;

    public Itemset() {
    }

    public Itemset(int clas) {
        this.itemset = new ArrayList();
        this.clas = clas;
        this.support = 0.0;
        this.supportRule = 0.0;
    }

    public Itemset clone() {
        Itemset d = new Itemset(this.clas);
        for (int i = 0; i < this.itemset.size(); ++i) {
            d.add(this.itemset.get(i).clone());
        }
        d.clas = this.clas;
        d.support = this.support;
        d.supportRule = this.supportRule;
        return d;
    }

    public void add(Item item) {
        this.itemset.add(item);
    }

    public Item get(int pos) {
        return this.itemset.get(pos);
    }

    public Item remove(int pos) {
        return this.itemset.remove(pos);
    }

    public int size() {
        return this.itemset.size();
    }

    public double getSupport() {
        return this.support;
    }

    public double getSupportClass() {
        return this.supportRule;
    }

    public int getClas() {
        return this.clas;
    }

    public void setClas(int clas) {
        this.clas = clas;
    }

    public boolean isEqual(Itemset a) {
        if (this.itemset.size() != a.size()) {
            return false;
        }
        for (int i = 0; i < this.itemset.size(); ++i) {
            Item item = this.itemset.get(i);
            if (item.isEqual(a.get(i))) continue;
            return false;
        }
        return this.clas == a.getClas();
    }

    public void calculateSupports(myDataset train) {
        this.support = 0.0;
        this.supportRule = 0.0;
        for (int i = 0; i < train.size(); ++i) {
            double degree = this.degree(train.getExampleFGTTFS(i));
            this.support += degree;
            if (train.getOutputAsInteger(i) != this.clas) continue;
            this.supportRule += degree;
        }
        this.support /= (double)train.getnData();
        this.supportRule /= (double)train.getnData();
    }

    private double degree(double[][] ejemplo) {
        return this.degreeProduct(ejemplo);
    }

    private double degreeProduct(double[][] example) {
        double degree = 1.0;
        for (int i = 0; i < this.itemset.size(); ++i) {
            Item item = this.itemset.get(i);
            degree *= example[item.getVariable()][item.getValue()];
        }
        return degree;
    }
}

