/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Missing_Values.kmeansImpute;

import keel.Algorithms.Preprocess.Missing_Values.kmeansImpute.FreqList;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class gCenter {
    String[][] gravCenters;
    int numCenters;
    int[] centerOf;
    int ndatos;

    public gCenter() {
        this.gravCenters = null;
        this.centerOf = null;
        this.numCenters = 0;
        this.ndatos = 0;
    }

    public gCenter(int k, int ndatos, int nvariables) {
        this.gravCenters = new String[k][nvariables];
        this.numCenters = k;
        this.centerOf = new int[ndatos];
        this.ndatos = ndatos;
    }

    public double distance(Instance i, int k) {
        double dist = 0.0;
        int in = 0;
        int out = 0;
        int tipo = 0;
        int direccion = 0;
        int nvariables = Attributes.getNumAttributes();
        for (int l = 0; l < nvariables; ++l) {
            Attribute a = Attributes.getAttribute(l);
            direccion = a.getDirectionAttribute();
            tipo = a.getType();
            if (direccion == 1) {
                if (tipo != 0 && !i.getInputMissingValues(in) && this.gravCenters[k][l].compareTo("<null>") != 0) {
                    dist += Math.sqrt((i.getInputRealValues(in) - new Double(this.gravCenters[k][l])) * (i.getInputRealValues(in) - new Double(this.gravCenters[k][l])));
                } else if (!i.getInputMissingValues(in) && i.getInputNominalValues(in) != this.gravCenters[k][l]) {
                    dist += 1.0;
                }
                ++in;
                continue;
            }
            if (direccion != 2) continue;
            if (tipo != 0 && !i.getOutputMissingValues(out)) {
                dist += (i.getOutputRealValues(out) - new Double(this.gravCenters[k][l])) * (i.getOutputRealValues(out) - new Double(this.gravCenters[k][l]));
            } else if (!i.getOutputMissingValues(out) && i.getOutputNominalValues(out) != this.gravCenters[k][l]) {
                dist += 1.0;
            }
            ++out;
        }
        return dist;
    }

    public int nearestCenter(Instance inst) {
        int nearest = 0;
        double minDist = this.distance(inst, 0);
        boolean in = false;
        boolean out = false;
        boolean tipo = false;
        boolean direccion = false;
        for (int k = 1; k < this.numCenters; ++k) {
            double distAct = this.distance(inst, k);
            if (!(distAct < minDist)) continue;
            minDist = distAct;
            nearest = k;
        }
        return nearest;
    }

    public void copyCenter(Instance i, int c) {
        int in = 0;
        int out = 0;
        int tipo = 0;
        int direccion = 0;
        int nvariables = Attributes.getNumAttributes();
        for (int l = 0; l < nvariables; ++l) {
            Attribute a = Attributes.getAttribute(l);
            direccion = a.getDirectionAttribute();
            tipo = a.getType();
            if (direccion == 1) {
                this.gravCenters[c][l] = tipo != 0 && !i.getInputMissingValues(in) ? String.valueOf(i.getInputRealValues(in)) : (!i.getInputMissingValues(in) ? i.getInputNominalValues(in) : "<null>");
                ++in;
                continue;
            }
            if (direccion != 2) continue;
            this.gravCenters[c][l] = tipo != 0 && !i.getOutputMissingValues(out) ? String.valueOf(i.getOutputRealValues(out)) : (!i.getOutputMissingValues(out) ? i.getOutputNominalValues(out) : "<null>");
            ++out;
        }
    }

    public void recalculateCenters(InstanceSet IS) {
        double tmp;
        int in = 0;
        int out = 0;
        int tipo = 0;
        int direccion = 0;
        int nvariables = Attributes.getNumAttributes();
        FreqList[][] modes = new FreqList[this.numCenters][nvariables];
        int[][] nInst = new int[this.numCenters][nvariables];
        String[][] oldGC = this.gravCenters;
        this.gravCenters = new String[this.numCenters][nvariables];
        for (int a = 0; a < this.numCenters; ++a) {
            for (int b = 0; b < nvariables; ++b) {
                nInst[a][b] = 0;
                this.gravCenters[a][b] = "a";
                modes[a][b] = new FreqList();
            }
        }
        for (int m = 0; m < this.ndatos; ++m) {
            Attribute a;
            int l;
            Instance i = IS.getInstance(m);
            int c = this.getClusterOf(m);
            in = 0;
            out = 0;
            for (l = 0; l < nvariables; ++l) {
                a = Attributes.getAttribute(l);
                direccion = a.getDirectionAttribute();
                tipo = a.getType();
                if (direccion == 1) {
                    if (tipo != 0 && !i.getInputMissingValues(in)) {
                        int[] nArray = nInst[c];
                        int n = l;
                        nArray[n] = nArray[n] + 1;
                        if (this.gravCenters[c][l].compareTo("a") == 0) {
                            this.gravCenters[c][l] = new String("0");
                        }
                        tmp = new Double(this.gravCenters[c][l]);
                        this.gravCenters[c][l] = String.valueOf(tmp += i.getInputRealValues(in));
                    } else if (!i.getInputMissingValues(in)) {
                        modes[c][l].AddElement(i.getInputNominalValues(in));
                        int[] nArray = nInst[c];
                        int n = l;
                        nArray[n] = nArray[n] + 1;
                    }
                    ++in;
                    continue;
                }
                if (direccion != 2) continue;
                if (tipo != 0 && !i.getOutputMissingValues(out)) {
                    int[] nArray = nInst[c];
                    int n = l;
                    nArray[n] = nArray[n] + 1;
                    if (this.gravCenters[c][l].compareTo("a") == 0) {
                        this.gravCenters[c][l] = new String("0");
                    }
                    tmp = new Double(this.gravCenters[c][l]);
                    this.gravCenters[c][l] = String.valueOf(tmp += i.getOutputRealValues(out));
                } else if (!i.getOutputMissingValues(out)) {
                    int[] nArray = nInst[c];
                    int n = l;
                    nArray[n] = nArray[n] + 1;
                    modes[c][l].AddElement(i.getOutputNominalValues(out));
                }
                ++out;
            }
            for (l = 0; l < nvariables; ++l) {
                a = Attributes.getAttribute(l);
                direccion = a.getDirectionAttribute();
                tipo = a.getType();
                if (tipo != 0) continue;
                this.gravCenters[c][l] = modes[c][l].numElems() > 0 ? modes[c][l].mostCommon().getValue() : oldGC[c][l];
            }
        }
        for (int b = 0; b < nvariables; ++b) {
            Attribute at = Attributes.getAttribute(b);
            tipo = at.getType();
            if (tipo == 0) continue;
            for (int a = 0; a < this.numCenters; ++a) {
                if (this.gravCenters[a][b].compareTo("a") != 0) {
                    tmp = new Double(this.gravCenters[a][b]);
                    this.gravCenters[a][b] = String.valueOf(tmp /= (double)nInst[a][b]);
                    continue;
                }
                this.gravCenters[a][b] = oldGC[a][b];
            }
        }
    }

    public void setClusterOf(Instance i, int orderOf_i) {
        this.centerOf[orderOf_i] = this.nearestCenter(i);
    }

    public int getClusterOf(int orderOf_i) {
        return this.centerOf[orderOf_i];
    }

    public String valueAt(int cluster, int position) {
        return this.gravCenters[cluster][position];
    }
}

