/*
 * Decompiled with CFR 0.152.
 */
package javolution.io;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import javolution.lang.Reusable;

public final class Utf8ByteBufferWriter
extends Writer
implements Reusable {
    private ByteBuffer _byteBuffer;
    private char _highSurrogate;

    public Utf8ByteBufferWriter setByteBuffer(ByteBuffer byteBuffer) {
        if (this._byteBuffer != null) {
            throw new IllegalStateException("Writer not closed or reset");
        }
        this._byteBuffer = byteBuffer;
        return this;
    }

    public void write(char c) throws IOException {
        if (c < '\ud800' || c > '\udfff') {
            this.write((int)c);
        } else if (c < '\udc00') {
            this._highSurrogate = c;
        } else {
            int n = (this._highSurrogate - 55296 << 10) + (c - 56320) + 65536;
            this.write(n);
        }
    }

    public void write(int n) throws IOException {
        if ((n & 0xFFFFFF80) == 0) {
            this._byteBuffer.put((byte)n);
        } else {
            this.write2(n);
        }
    }

    private void write2(int n) throws IOException {
        if ((n & 0xFFFFF800) == 0) {
            this._byteBuffer.put((byte)(0xC0 | n >> 6));
            this._byteBuffer.put((byte)(0x80 | n & 0x3F));
        } else if ((n & 0xFFFF0000) == 0) {
            this._byteBuffer.put((byte)(0xE0 | n >> 12));
            this._byteBuffer.put((byte)(0x80 | n >> 6 & 0x3F));
            this._byteBuffer.put((byte)(0x80 | n & 0x3F));
        } else if ((n & 0xFF200000) == 0) {
            this._byteBuffer.put((byte)(0xF0 | n >> 18));
            this._byteBuffer.put((byte)(0x80 | n >> 12 & 0x3F));
            this._byteBuffer.put((byte)(0x80 | n >> 6 & 0x3F));
            this._byteBuffer.put((byte)(0x80 | n & 0x3F));
        } else if ((n & 0xF4000000) == 0) {
            this._byteBuffer.put((byte)(0xF8 | n >> 24));
            this._byteBuffer.put((byte)(0x80 | n >> 18 & 0x3F));
            this._byteBuffer.put((byte)(0x80 | n >> 12 & 0x3F));
            this._byteBuffer.put((byte)(0x80 | n >> 6 & 0x3F));
            this._byteBuffer.put((byte)(0x80 | n & 0x3F));
        } else if ((n & Integer.MIN_VALUE) == 0) {
            this._byteBuffer.put((byte)(0xFC | n >> 30));
            this._byteBuffer.put((byte)(0x80 | n >> 24 & 0x3F));
            this._byteBuffer.put((byte)(0x80 | n >> 18 & 0x3F));
            this._byteBuffer.put((byte)(0x80 | n >> 12 & 0x3F));
            this._byteBuffer.put((byte)(0x80 | n >> 6 & 0x3F));
            this._byteBuffer.put((byte)(0x80 | n & 0x3F));
        } else {
            throw new CharConversionException("Illegal character U+" + Integer.toHexString(n));
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            char c;
            if ((c = cArray[n4++]) < '\u0080') {
                this._byteBuffer.put((byte)c);
                continue;
            }
            this.write(c);
        }
    }

    public void write(String string, int n, int n2) throws IOException {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            char c;
            if ((c = string.charAt(n4++)) < '\u0080') {
                this._byteBuffer.put((byte)c);
                continue;
            }
            this.write(c);
        }
    }

    public void write(CharSequence charSequence) throws IOException {
        int n = charSequence.length();
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = charSequence.charAt(n2++)) < '\u0080') {
                this._byteBuffer.put((byte)c);
                continue;
            }
            this.write(c);
        }
    }

    public void flush() throws IOException {
        if (this._byteBuffer == null) {
            throw new IOException("Writer closed");
        }
    }

    public void close() throws IOException {
        if (this._byteBuffer != null) {
            this.reset();
        }
    }

    public void reset() {
        this._byteBuffer = null;
        this._highSurrogate = '\u0000';
    }
}

