/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml.pull;

import javolution.realtime.ObjectFactory;
import javolution.util.FastComparator;

final class CharSequenceImpl
implements CharSequence,
Comparable {
    private static final ObjectFactory FACTORY = new ObjectFactory(){

        protected Object create() {
            return new CharSequenceImpl();
        }
    };
    static final CharSequenceImpl EMPTY = new CharSequenceImpl("");
    char[] data;
    int offset;
    int length;

    CharSequenceImpl() {
    }

    CharSequenceImpl(String string) {
        this.data = string.toCharArray();
        this.offset = 0;
        this.length = string.length();
    }

    public int length() {
        return this.length;
    }

    public char charAt(int n) {
        if (n < 0 || n >= this.length) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        return this.data[this.offset + n];
    }

    public CharSequence subSequence(int n, int n2) {
        if (n < 0 || n2 < 0 || n > n2 || n2 > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        CharSequenceImpl charSequenceImpl = (CharSequenceImpl)FACTORY.object();
        charSequenceImpl.data = this.data;
        charSequenceImpl.offset = this.offset + n;
        charSequenceImpl.length = n2 - n;
        return charSequenceImpl;
    }

    public String toString() {
        return new String(this.data, this.offset, this.length);
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.offset;
        for (int i = 0; i < this.length; ++i) {
            n = 31 * n + this.data[n2++];
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof CharSequenceImpl) {
            return this.equals((CharSequenceImpl)object);
        }
        if (object instanceof String) {
            return this.equals((String)object);
        }
        if (object instanceof CharSequence) {
            return this.equals((CharSequence)object);
        }
        return false;
    }

    public boolean equals(CharSequenceImpl charSequenceImpl) {
        if (charSequenceImpl == null) {
            return false;
        }
        if (this.length != charSequenceImpl.length) {
            return false;
        }
        char[] cArray = charSequenceImpl.data;
        int n = this.offset + this.length;
        int n2 = this.offset;
        int n3 = charSequenceImpl.offset;
        while (n2 < n) {
            if (this.data[n2++] == cArray[n3++]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(String string) {
        if (string == null) {
            return false;
        }
        if (this.length != string.length()) {
            return false;
        }
        int n = 0;
        int n2 = this.offset;
        while (n < this.length) {
            if (this.data[n2++] == string.charAt(n++)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(CharSequence charSequence) {
        if (charSequence == null) {
            return false;
        }
        if (this.length != charSequence.length()) {
            return false;
        }
        int n = 0;
        int n2 = this.offset;
        while (n < this.length) {
            if (this.data[n2++] == charSequence.charAt(n++)) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object object) {
        return FastComparator.LEXICAL.compare(this, object);
    }
}

