/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.realarray.rec;

import net.sf.jclec.IPopulation;
import net.sf.jclec.realarray.RealArrayIndividual;
import net.sf.jclec.realarray.rec.UniformCrossover2x1;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BLXAlphaCrossover<I extends RealArrayIndividual>
extends UniformCrossover2x1<I> {
    private static final long serialVersionUID = 6802959322946378018L;
    protected double alpha;

    public BLXAlphaCrossover() {
    }

    public BLXAlphaCrossover(IPopulation<I> context) {
        super(context);
    }

    public final double getAlpha() {
        return this.alpha;
    }

    public final void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public void configure(Configuration settings) {
        super.configure(settings);
        double alpha = settings.getDouble("[@alpha]", 0.5);
        this.setAlpha(alpha);
    }

    public boolean equals(Object other) {
        if (other instanceof BLXAlphaCrossover) {
            BLXAlphaCrossover o = (BLXAlphaCrossover)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.locusRecProb, o.locusRecProb);
            eb.append(this.alpha, o.alpha);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    protected void recombineLocus(double[] p0_genome, double[] p1_genome, double[] s0_genome, int locusIndex) {
        double cmax = Math.max(p0_genome[locusIndex], p1_genome[locusIndex]);
        double cmin = Math.min(p1_genome[locusIndex], p0_genome[locusIndex]);
        double inf = cmin - (cmax - cmin) * this.alpha;
        double sup = cmax + (cmax - cmin) * this.alpha;
        s0_genome[locusIndex] = inf + this.randgen.raw() * (sup - inf);
        s0_genome[locusIndex] = this.genotypeSchema[locusIndex].nearestOf(s0_genome[locusIndex]);
    }

    @Override
    protected double defaultLocusRecProb() {
        return 0.6;
    }
}

