/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.vocabulary;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"CONCEPT_ID", "CONCEPT_NAME", "STANDARD_CONCEPT", "STANDARD_CONCEPT_CAPTION", "INVALID_REASON", "INVALID_REASON_CAPTION", "CONCEPT_CODE", "DOMAIN_ID", "VOCABULARY_ID", "CONCEPT_CLASS_ID"})
public class Concept {
    @JsonProperty(value="CONCEPT_ID")
    public Long conceptId;
    @JsonProperty(value="CONCEPT_NAME")
    public String conceptName;
    @JsonProperty(value="STANDARD_CONCEPT")
    public String standardConcept;
    @JsonProperty(value="INVALID_REASON")
    public String invalidReason;
    @JsonProperty(value="CONCEPT_CODE")
    public String conceptCode;
    @JsonProperty(value="DOMAIN_ID")
    public String domainId;
    @JsonProperty(value="VOCABULARY_ID")
    public String vocabularyId;
    @JsonProperty(value="CONCEPT_CLASS_ID")
    public String conceptClassId;

    @JsonProperty(value="STANDARD_CONCEPT_CAPTION")
    public String GetStandardConcept() {
        if (this.standardConcept == null) {
            return "Unknown";
        }
        switch (this.standardConcept) {
            case "N": {
                return "Non-Standard";
            }
            case "S": {
                return "Standard";
            }
            case "C": {
                return "Classification";
            }
        }
        return "Unknown";
    }

    @JsonProperty(value="INVALID_REASON_CAPTION")
    public String GetInvalidReason() {
        if (this.invalidReason == null) {
            return "Unknown";
        }
        switch (this.invalidReason) {
            case "V": {
                return "Valid";
            }
            case "D": {
                return "Invalid";
            }
            case "U": {
                return "Invalid";
            }
        }
        return "Unknown";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Concept)) {
            return false;
        }
        Concept other = (Concept)o;
        return Objects.equals(this.conceptId, other.conceptId) && Objects.equals(this.conceptName, other.conceptName) && Objects.equals(this.standardConcept, other.standardConcept) && Objects.equals(this.invalidReason, other.invalidReason) && Objects.equals(this.conceptCode, other.conceptCode) && Objects.equals(this.domainId, other.domainId) && Objects.equals(this.vocabularyId, other.vocabularyId) && Objects.equals(this.conceptClassId, other.conceptClassId);
    }

    public int hashCode() {
        return Objects.hash(this.conceptId, this.conceptName, this.standardConcept, this.invalidReason, this.conceptCode, this.domainId, this.vocabularyId, this.conceptClassId);
    }
}

