/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.cohortdefinition.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ohdsi.circe.cohortdefinition.DateAdjustment;
import org.ohdsi.circe.cohortdefinition.DrugExposure;
import org.ohdsi.circe.cohortdefinition.builders.BuilderUtils;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaColumn;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaSqlBuilder;
import org.ohdsi.circe.helper.ResourceHelper;

public class DrugExposureSqlBuilder<T extends DrugExposure>
extends CriteriaSqlBuilder<T> {
    private static final String DRUG_EXPOSURE_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/drugExposure.sql");
    private final Set<CriteriaColumn> DEFAULT_COLUMNS = new HashSet<CriteriaColumn>(Arrays.asList(CriteriaColumn.START_DATE, CriteriaColumn.END_DATE, CriteriaColumn.VISIT_ID));
    private final List<String> DEFAULT_SELECT_COLUMNS = new ArrayList<String>(Arrays.asList("de.person_id", "de.drug_exposure_id", "de.drug_concept_id", "de.visit_occurrence_id", "days_supply", "quantity", "refills"));

    @Override
    protected Set<CriteriaColumn> getDefaultColumns() {
        return this.DEFAULT_COLUMNS;
    }

    @Override
    protected String getQueryTemplate() {
        return DRUG_EXPOSURE_TEMPLATE;
    }

    @Override
    protected String getTableColumnForCriteriaColumn(CriteriaColumn column) {
        switch (column) {
            case DAYS_SUPPLY: {
                return "C.days_supply";
            }
            case DOMAIN_CONCEPT: {
                return "C.drug_concept_id";
            }
            case DURATION: {
                return "DATEDIFF(d, C.start_date, C.end_date)";
            }
            case QUANTITY: {
                return "C.quantity";
            }
            case REFILLS: {
                return "C.refills";
            }
        }
        throw new IllegalArgumentException("Invalid CriteriaColumn for Drug Exposure:" + column.toString());
    }

    @Override
    protected String embedCodesetClause(String query, T criteria) {
        return StringUtils.replace((String)query, (String)"@codesetClause", (String)BuilderUtils.getCodesetJoinExpression(((DrugExposure)criteria).codesetId, "de.drug_concept_id", ((DrugExposure)criteria).drugSourceConcept, "de.drug_source_concept_id"));
    }

    @Override
    protected String embedOrdinalExpression(String query, T criteria, List<String> whereClauses) {
        if (((DrugExposure)criteria).first != null && ((DrugExposure)criteria).first.booleanValue()) {
            whereClauses.add("C.ordinal = 1");
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)", row_number() over (PARTITION BY de.person_id ORDER BY de.drug_exposure_start_date, de.drug_exposure_id) as ordinal");
        } else {
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)"");
        }
        return query;
    }

    @Override
    protected List<String> resolveSelectClauses(T criteria) {
        ArrayList<String> selectCols = new ArrayList<String>(this.DEFAULT_SELECT_COLUMNS);
        if (((DrugExposure)criteria).drugType != null && ((DrugExposure)criteria).drugType.length > 0) {
            selectCols.add("de.drug_type_concept_id");
        }
        if (((DrugExposure)criteria).stopReason != null) {
            selectCols.add("de.stop_reason");
        }
        if (((DrugExposure)criteria).routeConcept != null && ((DrugExposure)criteria).routeConcept.length > 0) {
            selectCols.add("de.route_concept_id");
        }
        if (((DrugExposure)criteria).effectiveDrugDose != null) {
            selectCols.add("de.effective_drug_dose");
        }
        if (((DrugExposure)criteria).doseUnit != null && ((DrugExposure)criteria).doseUnit.length > 0) {
            selectCols.add("de.dose_unit_concept_id");
        }
        if (((DrugExposure)criteria).lotNumber != null) {
            selectCols.add("de.lot_number");
        }
        if (((DrugExposure)criteria).providerSpecialty != null && ((DrugExposure)criteria).providerSpecialty.length > 0) {
            selectCols.add("de.provider_id");
        }
        if (((DrugExposure)criteria).dateAdjustment != null) {
            selectCols.add(BuilderUtils.getDateAdjustmentExpression(((DrugExposure)criteria).dateAdjustment, ((DrugExposure)criteria).dateAdjustment.startWith == DateAdjustment.DateType.START_DATE ? "de.drug_exposure_start_date" : "COALESCE(de.drug_exposure_end_date, DATEADD(day,de.days_supply,de.drug_exposure_start_date), DATEADD(day,1,de.drug_exposure_start_date))", ((DrugExposure)criteria).dateAdjustment.endWith == DateAdjustment.DateType.START_DATE ? "de.drug_exposure_start_date" : "COALESCE(de.drug_exposure_end_date, DATEADD(day,de.days_supply,de.drug_exposure_start_date), DATEADD(day,1,de.drug_exposure_start_date))"));
        } else {
            selectCols.add("de.drug_exposure_start_date as start_date, COALESCE(de.drug_exposure_end_date, DATEADD(day,de.days_supply,de.drug_exposure_start_date), DATEADD(day,1,de.drug_exposure_start_date)) as end_date");
        }
        return selectCols;
    }

    @Override
    protected List<String> resolveJoinClauses(T criteria) {
        ArrayList<String> joinClauses = new ArrayList<String>();
        if (((DrugExposure)criteria).age != null || ((DrugExposure)criteria).gender != null && ((DrugExposure)criteria).gender.length > 0) {
            joinClauses.add("JOIN @cdm_database_schema.PERSON P on C.person_id = P.person_id");
        }
        if (((DrugExposure)criteria).visitType != null && ((DrugExposure)criteria).visitType.length > 0) {
            joinClauses.add("JOIN @cdm_database_schema.VISIT_OCCURRENCE V on C.visit_occurrence_id = V.visit_occurrence_id and C.person_id = V.person_id");
        }
        if (((DrugExposure)criteria).providerSpecialty != null && ((DrugExposure)criteria).providerSpecialty.length > 0) {
            joinClauses.add("LEFT JOIN @cdm_database_schema.PROVIDER PR on C.provider_id = PR.provider_id");
        }
        return joinClauses;
    }

    @Override
    protected List<String> resolveWhereClauses(T criteria) {
        List<String> whereClauses = super.resolveWhereClauses(criteria);
        if (((DrugExposure)criteria).occurrenceStartDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.start_date", ((DrugExposure)criteria).occurrenceStartDate));
        }
        if (((DrugExposure)criteria).occurrenceEndDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.start_date", ((DrugExposure)criteria).occurrenceEndDate));
        }
        if (((DrugExposure)criteria).drugType != null && ((DrugExposure)criteria).drugType.length > 0) {
            ArrayList<Long> conceptIds = BuilderUtils.getConceptIdsFromConcepts(((DrugExposure)criteria).drugType);
            whereClauses.add(String.format("C.drug_type_concept_id %s in (%s)", ((DrugExposure)criteria).drugTypeExclude ? "not" : "", StringUtils.join(conceptIds, (String)",")));
        }
        if (((DrugExposure)criteria).stopReason != null) {
            whereClauses.add(BuilderUtils.buildTextFilterClause("C.stop_reason", ((DrugExposure)criteria).stopReason));
        }
        if (((DrugExposure)criteria).refills != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("C.refills", ((DrugExposure)criteria).refills));
        }
        if (((DrugExposure)criteria).quantity != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("C.quantity", ((DrugExposure)criteria).quantity, ".4f"));
        }
        if (((DrugExposure)criteria).daysSupply != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("C.days_supply", ((DrugExposure)criteria).daysSupply));
        }
        if (((DrugExposure)criteria).routeConcept != null && ((DrugExposure)criteria).routeConcept.length > 0) {
            whereClauses.add(String.format("C.route_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((DrugExposure)criteria).routeConcept), (String)",")));
        }
        if (((DrugExposure)criteria).effectiveDrugDose != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("C.effective_drug_dose", ((DrugExposure)criteria).effectiveDrugDose, ".4f"));
        }
        if (((DrugExposure)criteria).doseUnit != null && ((DrugExposure)criteria).doseUnit.length > 0) {
            whereClauses.add(String.format("C.dose_unit_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((DrugExposure)criteria).doseUnit), (String)",")));
        }
        if (((DrugExposure)criteria).lotNumber != null) {
            whereClauses.add(BuilderUtils.buildTextFilterClause("C.lot_number", ((DrugExposure)criteria).lotNumber));
        }
        if (((DrugExposure)criteria).age != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("YEAR(C.start_date) - P.year_of_birth", ((DrugExposure)criteria).age));
        }
        if (((DrugExposure)criteria).gender != null && ((DrugExposure)criteria).gender.length > 0) {
            whereClauses.add(String.format("P.gender_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((DrugExposure)criteria).gender), (String)",")));
        }
        if (((DrugExposure)criteria).providerSpecialty != null && ((DrugExposure)criteria).providerSpecialty.length > 0) {
            whereClauses.add(String.format("PR.specialty_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((DrugExposure)criteria).providerSpecialty), (String)",")));
        }
        if (((DrugExposure)criteria).visitType != null && ((DrugExposure)criteria).visitType.length > 0) {
            whereClauses.add(String.format("V.visit_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((DrugExposure)criteria).visitType), (String)",")));
        }
        return whereClauses;
    }
}

