/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ohdsi.circe.check.WarningSeverity;
import org.ohdsi.circe.check.checkers.BaseCorelatedCriteriaCheck;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.check.utils.CriteriaNameHelper;
import org.ohdsi.circe.cohortdefinition.CohortExpression;
import org.ohdsi.circe.cohortdefinition.CorelatedCriteria;
import org.ohdsi.circe.cohortdefinition.Window;

public class TimePatternCheck
extends BaseCorelatedCriteriaCheck {
    private List<TimeWindowInfo> timeWindowInfoList = new ArrayList<TimeWindowInfo>();

    @Override
    protected WarningSeverity defineSeverity() {
        return WarningSeverity.INFO;
    }

    @Override
    protected void checkCriteria(CorelatedCriteria criteria, String groupName, WarningReporter reporter) {
        String name = CriteriaNameHelper.getCriteriaName(criteria.criteria) + " criteria at " + groupName;
        this.timeWindowInfoList.add(new TimeWindowInfo(name, criteria.startWindow, criteria.endWindow));
    }

    @Override
    protected void afterCheck(WarningReporter reporter, CohortExpression expression) {
        TimeWindowInfo mostCommonInfo;
        List startDays = this.timeWindowInfoList.stream().map(info -> this.startDays(((TimeWindowInfo)info).start)).collect(Collectors.toList());
        Map freq = startDays.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        long maxFreq = freq.values().stream().mapToLong(v -> v).max().orElse(0L);
        if (maxFreq > 1L && Objects.nonNull(mostCommonInfo = (TimeWindowInfo)this.timeWindowInfoList.stream().filter(ti -> {
            long currFreq = freq.getOrDefault(this.startDays(((TimeWindowInfo)ti).start), 0L);
            return currFreq == maxFreq;
        }).findFirst().orElse(null))) {
            this.timeWindowInfoList.forEach(info -> {
                int start = this.startDays(((TimeWindowInfo)info).start);
                long currFreq = freq.getOrDefault(start, 0L);
                if (maxFreq - currFreq > 0L) {
                    reporter.add("%s time window differs from most common pattern prior '%s', shouldn't that be a valid pattern?", info.getName(), this.formatTimeWindow(mostCommonInfo));
                }
            });
        }
    }

    private String formatTimeWindow(TimeWindowInfo ti) {
        String result = "";
        if (ti != null && ti.start != null && ((TimeWindowInfo)ti).start.start != null) {
            result = result + this.formatDays(((TimeWindowInfo)ti).start.start) + " days " + this.formatCoeff(((TimeWindowInfo)ti).start.start);
        }
        if (ti != null && ti.start != null && ((TimeWindowInfo)ti).start.end != null) {
            result = result + " and " + this.formatDays(((TimeWindowInfo)ti).start.end) + " days " + this.formatCoeff(((TimeWindowInfo)ti).start.end);
        }
        return result;
    }

    private String formatDays(Window.Endpoint endpoint) {
        return Objects.nonNull(endpoint.days) ? String.valueOf(endpoint.days) : "all";
    }

    private String formatCoeff(Window.Endpoint endpoint) {
        return endpoint.coeff < 0 ? "before " : "after ";
    }

    private Integer startDays(Window window) {
        return Objects.nonNull(window) && Objects.nonNull(window.start) ? (Objects.nonNull(window.start.days) ? window.start.days : 0) * window.start.coeff : 0;
    }

    class TimeWindowInfo {
        private String name;
        private Window start;
        private Window end;

        public TimeWindowInfo(String name, Window start, Window end) {
            this.name = name;
            this.start = start;
            this.end = end;
        }

        public String getName() {
            return this.name;
        }

        public Window getStart() {
            return this.start;
        }

        public Window getEnd() {
            return this.end;
        }
    }
}

