/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.Objects;
import java.util.function.Consumer;
import org.ohdsi.circe.check.checkers.BaseCheckerFactory;
import org.ohdsi.circe.check.checkers.Comparisons;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.check.operations.Operations;
import org.ohdsi.circe.cohortdefinition.CohortExpression;
import org.ohdsi.circe.cohortdefinition.ConditionEra;
import org.ohdsi.circe.cohortdefinition.ConditionOccurrence;
import org.ohdsi.circe.cohortdefinition.Criteria;
import org.ohdsi.circe.cohortdefinition.DateRange;
import org.ohdsi.circe.cohortdefinition.Death;
import org.ohdsi.circe.cohortdefinition.DemographicCriteria;
import org.ohdsi.circe.cohortdefinition.DeviceExposure;
import org.ohdsi.circe.cohortdefinition.DoseEra;
import org.ohdsi.circe.cohortdefinition.DrugEra;
import org.ohdsi.circe.cohortdefinition.DrugExposure;
import org.ohdsi.circe.cohortdefinition.LocationRegion;
import org.ohdsi.circe.cohortdefinition.Measurement;
import org.ohdsi.circe.cohortdefinition.NumericRange;
import org.ohdsi.circe.cohortdefinition.Observation;
import org.ohdsi.circe.cohortdefinition.ObservationPeriod;
import org.ohdsi.circe.cohortdefinition.PayerPlanPeriod;
import org.ohdsi.circe.cohortdefinition.Period;
import org.ohdsi.circe.cohortdefinition.ProcedureOccurrence;
import org.ohdsi.circe.cohortdefinition.Specimen;
import org.ohdsi.circe.cohortdefinition.VisitDetail;
import org.ohdsi.circe.cohortdefinition.VisitOccurrence;

public class RangeCheckerFactory
extends BaseCheckerFactory {
    private static final String WARNING_EMPTY_START_VALUE = "%s in the %s has empty %s start value";
    private static final String WARNING_EMPTY_END_VALUE = "%s in the %s has empty %s end value";
    private static final String WARNING_START_GREATER_THAN_END = "%s in the %s has start value greater than end in %s";
    private static final String WARNING_START_IS_NEGATIVE = "%s in the %s start value is negative at %s";
    private static final String WARNING_DATE_IS_INVALID = "%s in the %s has invalid date value at %s";
    private static final String ROOT_OBJECT = "root object";

    private RangeCheckerFactory(WarningReporter reporter, String groupName) {
        super(reporter, groupName);
    }

    public static RangeCheckerFactory getFactory(WarningReporter reporter, String groupName) {
        return new RangeCheckerFactory(reporter, groupName);
    }

    @Override
    protected Consumer<Criteria> getCheck(Criteria criteria) {
        Consumer<Criteria> result = c -> {};
        if (criteria instanceof ConditionEra) {
            result = c -> {
                ConditionEra conditionEra = (ConditionEra)c;
                this.checkRange(conditionEra.ageAtStart, "condition era", "age at era start");
                this.checkRange(conditionEra.ageAtEnd, "condition era", "age at era end");
                this.checkRange(conditionEra.eraLength, "condition era", "era length");
                this.checkRange(conditionEra.occurrenceCount, "condition era", "occurrence count");
                this.checkRange(conditionEra.eraStartDate, "condition era", "era start date");
                this.checkRange(conditionEra.eraEndDate, "condition era", "era end date");
            };
        } else if (criteria instanceof ConditionOccurrence) {
            result = c -> {
                ConditionOccurrence co = (ConditionOccurrence)c;
                this.checkRange(co.occurrenceStartDate, "condition occurrence", "occurrence start date");
                this.checkRange(co.occurrenceEndDate, "condition occurrence", "occurrence end date");
                this.checkRange(co.age, "condition occurrence", "age");
            };
        } else if (criteria instanceof Death) {
            result = c -> {
                Death death = (Death)c;
                this.checkRange(death.age, "death", "age");
                this.checkRange(death.occurrenceStartDate, "death", "occurrence start date");
            };
        } else if (criteria instanceof DeviceExposure) {
            result = c -> {
                DeviceExposure de = (DeviceExposure)c;
                this.checkRange(de.occurrenceStartDate, "device exposure", "occurrence start date");
                this.checkRange(de.occurrenceEndDate, "device exposure", "occurrence end date");
                this.checkRange(de.quantity, "device exposure", "quantity");
                this.checkRange(de.age, "device exposure", "age");
            };
        } else if (criteria instanceof DoseEra) {
            result = c -> {
                DoseEra doseEra = (DoseEra)c;
                this.checkRange(doseEra.eraStartDate, "dose era", "era start date");
                this.checkRange(doseEra.eraEndDate, "dose era", "era end date");
                this.checkRange(doseEra.doseValue, "dose era", "dose value");
                this.checkRange(doseEra.eraLength, "dose era", "era length");
                this.checkRange(doseEra.ageAtStart, "dose era", "age at start");
                this.checkRange(doseEra.ageAtEnd, "dose era", "age at end");
            };
        } else if (criteria instanceof DrugEra) {
            result = c -> {
                DrugEra drugEra = (DrugEra)c;
                this.checkRange(drugEra.eraStartDate, "drug era", "era start date");
                this.checkRange(drugEra.eraEndDate, "drug era", "era end date");
                this.checkRange(drugEra.occurrenceCount, "drug era", "occurrence count");
                this.checkRange(drugEra.gapDays, "drug era", "gap days");
                this.checkRange(drugEra.eraLength, "drug era", "era length");
                this.checkRange(drugEra.ageAtStart, "drug era", "age at start");
                this.checkRange(drugEra.ageAtEnd, "drug era", "age at end");
            };
        } else if (criteria instanceof DrugExposure) {
            result = c -> {
                DrugExposure de = (DrugExposure)c;
                this.checkRange(de.occurrenceStartDate, "drug exposure", "occurrence start date");
                this.checkRange(de.occurrenceEndDate, "drug exposure", "occurrence end date");
                this.checkRange(de.refills, "drug exposure", "refills");
                this.checkRange(de.quantity, "drug exposure", "quantity");
                this.checkRange(de.daysSupply, "drug exposure", "days supply");
                this.checkRange(de.effectiveDrugDose, "drug exposure", "effective drug dose");
                this.checkRange(de.age, "drug exposure", "age");
            };
        } else if (criteria instanceof Measurement) {
            result = c -> {
                Measurement m = (Measurement)c;
                this.checkRange(m.occurrenceStartDate, "measurement", "occurrence start date");
                this.checkRange(m.valueAsNumber, "measurement", "value as number");
                this.checkRange(m.rangeLow, "measurement", "range low");
                this.checkRange(m.rangeHigh, "measurement", "range high");
                this.checkRange(m.rangeLowRatio, "measurement", "range low ratio");
                this.checkRange(m.rangeHighRatio, "measurement", "range high ratio");
                this.checkRange(m.age, "measurement", "age");
            };
        } else if (criteria instanceof Observation) {
            result = c -> {
                Observation o = (Observation)c;
                this.checkRange(o.occurrenceStartDate, "observation", "occurrence start date");
                this.checkRange(o.valueAsNumber, "observation", "value as number");
                this.checkRange(o.age, "observation", "age");
            };
        } else if (criteria instanceof ObservationPeriod) {
            result = c -> {
                ObservationPeriod op = (ObservationPeriod)c;
                this.checkRange(op.periodStartDate, "observation period", "period start date");
                this.checkRange(op.periodEndDate, "observation period", "period end date");
                this.checkRange(op.periodLength, "observation period", "period length");
                this.checkRange(op.ageAtStart, "observation period", "age at start");
                this.checkRange(op.ageAtEnd, "observation period", "age at end");
                this.checkRange(op.userDefinedPeriod, "observation period", "user defined period");
            };
        } else if (criteria instanceof ProcedureOccurrence) {
            result = c -> {
                ProcedureOccurrence po = (ProcedureOccurrence)c;
                this.checkRange(po.occurrenceStartDate, "procedure occurrence", "occurrence start date");
                this.checkRange(po.quantity, "procedure occurrence", "quantity");
                this.checkRange(po.age, "procedure occurrence", "age");
            };
        } else if (criteria instanceof Specimen) {
            result = c -> {
                Specimen specimen = (Specimen)c;
                this.checkRange(specimen.occurrenceStartDate, "specimen", "occurrence start date");
                this.checkRange(specimen.quantity, "specimen", "quantity");
                this.checkRange(specimen.age, "specimen", "age");
            };
        } else if (criteria instanceof VisitOccurrence) {
            result = c -> {
                VisitOccurrence vo = (VisitOccurrence)c;
                this.checkRange(vo.occurrenceStartDate, "visit occurrence", "occurrence start date");
                this.checkRange(vo.occurrenceEndDate, "visit occurrence", "occurrence end date");
                this.checkRange(vo.visitLength, "visit occurrence", "visit length");
                this.checkRange(vo.age, "visit occurrence", "age");
            };
        } else if (criteria instanceof VisitDetail) {
            result = c -> {
                VisitDetail vd = (VisitDetail)c;
                this.checkRange(vd.visitDetailStartDate, "visit detail", "visit detail start date");
                this.checkRange(vd.visitDetailEndDate, "visit detail", "visit detail end date");
                this.checkRange(vd.visitDetailLength, "visit detail", "visit detail length");
                this.checkRange(vd.age, "visit detail", "age");
            };
        } else if (criteria instanceof PayerPlanPeriod) {
            result = c -> {
                PayerPlanPeriod planPeriod = (PayerPlanPeriod)c;
                this.checkRange(planPeriod.periodStartDate, "payer plan period", "period start date");
                this.checkRange(planPeriod.periodEndDate, "payer plan period", "period end date");
                this.checkRange(planPeriod.periodLength, "payer plan period", "period length");
                this.checkRange(planPeriod.ageAtStart, "payer plan period", "age at start");
                this.checkRange(planPeriod.ageAtEnd, "payer plan period", "age at end");
                this.checkRange(planPeriod.userDefinedPeriod, "payer plan period", "user defined period");
            };
        } else if (criteria instanceof LocationRegion) {
            result = c -> {
                LocationRegion region = (LocationRegion)c;
                this.checkRange(region.endDate, "location region", "location region start date");
                this.checkRange(region.startDate, "location region", "location region end date");
            };
        }
        return result;
    }

    @Override
    protected Consumer<DemographicCriteria> getCheck(DemographicCriteria criteria) {
        Consumer<DemographicCriteria> result = c -> {
            this.checkRange(criteria.occurrenceEndDate, "demographic", "occurrence end date");
            this.checkRange(criteria.occurrenceStartDate, "demographic", "occurrence start date");
            this.checkRange(criteria.age, "demographic", "age");
        };
        return result;
    }

    private void checkRange(NumericRange range, String criteriaName, String attribute) {
        Consumer<String> warning = t -> this.reporter.add((String)t, this.groupName, criteriaName, attribute);
        Operations.match(range).when(r -> Objects.nonNull(r.op) && r.op.endsWith("bt")).then(r -> Operations.match(r).when(x -> Objects.isNull(x.value)).then(x -> warning.accept(WARNING_EMPTY_START_VALUE)).when(x -> Objects.isNull(x.extent)).then(x -> warning.accept(WARNING_EMPTY_END_VALUE)).when(Comparisons::startIsGreaterThanEnd).then(x -> warning.accept(WARNING_START_GREATER_THAN_END))).orElse(r -> Operations.match(r).when(Comparisons::isStartNegative).then(() -> warning.accept(WARNING_START_IS_NEGATIVE)).when(x -> Objects.isNull(x.value)).then(() -> warning.accept(WARNING_EMPTY_START_VALUE)));
    }

    private void checkRange(DateRange range, String criteriaName, String attribute) {
        Consumer<String> warning = t -> this.reporter.add((String)t, this.groupName, criteriaName, attribute);
        Operations.match(range).when(r -> Objects.nonNull(r.value) && Comparisons.isDateValid(r.value) == false).then(x -> warning.accept(WARNING_DATE_IS_INVALID)).when(r -> Objects.nonNull(r.op) && r.op.endsWith("bt")).then(r -> Operations.match(r).when(x -> Objects.isNull(x.value)).then(() -> warning.accept(WARNING_EMPTY_START_VALUE)).when(x -> Objects.isNull(x.extent)).then(() -> warning.accept(WARNING_EMPTY_END_VALUE)).when(x -> Objects.nonNull(x.extent) && Comparisons.isDateValid(x.extent) == false).then(() -> warning.accept(WARNING_DATE_IS_INVALID)).when(Comparisons::startIsGreaterThanEnd).then(() -> warning.accept(WARNING_START_GREATER_THAN_END))).orElse(r -> Operations.match(r).when(x -> Objects.isNull(x.value)).then(() -> warning.accept(WARNING_EMPTY_START_VALUE)));
    }

    public void checkRange(Period period, String criteriaName, String attribute) {
        Consumer<String> warning = t -> this.reporter.add((String)t, this.groupName, criteriaName, attribute);
        Operations.match(period).when(x -> Objects.nonNull(x.startDate) && Comparisons.isDateValid(x.startDate) == false).then(x -> warning.accept(WARNING_DATE_IS_INVALID)).when(x -> Objects.nonNull(x.endDate) && Comparisons.isDateValid(x.endDate) == false).then(x -> warning.accept(WARNING_DATE_IS_INVALID)).when(Comparisons::startIsGreaterThanEnd).then(x -> warning.accept(WARNING_START_GREATER_THAN_END));
    }

    public void check(CohortExpression expression) {
        this.checkRange(expression.censorWindow, ROOT_OBJECT, "censor window");
    }
}

