/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.ohdsi.circe.cohortdefinition.ConceptSet;
import org.ohdsi.circe.cohortdefinition.ConditionEra;
import org.ohdsi.circe.cohortdefinition.ConditionOccurrence;
import org.ohdsi.circe.cohortdefinition.Criteria;
import org.ohdsi.circe.cohortdefinition.DateRange;
import org.ohdsi.circe.cohortdefinition.Death;
import org.ohdsi.circe.cohortdefinition.DeviceExposure;
import org.ohdsi.circe.cohortdefinition.DoseEra;
import org.ohdsi.circe.cohortdefinition.DrugEra;
import org.ohdsi.circe.cohortdefinition.DrugExposure;
import org.ohdsi.circe.cohortdefinition.Measurement;
import org.ohdsi.circe.cohortdefinition.NumericRange;
import org.ohdsi.circe.cohortdefinition.Observation;
import org.ohdsi.circe.cohortdefinition.ObservationFilter;
import org.ohdsi.circe.cohortdefinition.Period;
import org.ohdsi.circe.cohortdefinition.ProcedureOccurrence;
import org.ohdsi.circe.cohortdefinition.Specimen;
import org.ohdsi.circe.cohortdefinition.VisitDetail;
import org.ohdsi.circe.cohortdefinition.VisitOccurrence;
import org.ohdsi.circe.cohortdefinition.Window;
import org.ohdsi.circe.vocabulary.Concept;

public class Comparisons {
    public static Boolean startIsGreaterThanEnd(NumericRange r) {
        return Objects.nonNull(r.value) && Objects.nonNull(r.extent) && r.value.intValue() > r.extent.intValue();
    }

    public static Boolean startIsGreaterThanEnd(DateRange r) {
        try {
            return Objects.nonNull(r.value) && Objects.nonNull(r.extent) && LocalDate.parse(r.value).isAfter(LocalDate.parse(r.extent));
        }
        catch (DateTimeParseException ignored) {
            return false;
        }
    }

    public static Boolean startIsGreaterThanEnd(Period p) {
        try {
            if (Objects.nonNull(p.startDate) && Objects.nonNull(p.endDate)) {
                LocalDate startDate = LocalDate.parse(p.startDate);
                LocalDate endDate = LocalDate.parse(p.endDate);
                return startDate.isAfter(endDate);
            }
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
        return false;
    }

    public static Boolean isDateValid(String date) {
        try {
            LocalDate.parse(date);
            return true;
        }
        catch (DateTimeParseException ignored) {
            return false;
        }
    }

    public static Boolean isStartNegative(NumericRange r) {
        return Objects.nonNull(r.value) && r.value.intValue() < 0;
    }

    public static Predicate<ConceptSet> compare(ConceptSet source) {
        return conceptSet -> {
            if (conceptSet.expression == source.expression) {
                return true;
            }
            if (Objects.nonNull(conceptSet.expression) && Objects.nonNull(source.expression) && conceptSet.expression.items.length == source.expression.items.length) {
                List sourceConcepts = Arrays.stream(source.expression.items).map(item -> item.concept).collect(Collectors.toList());
                return Arrays.stream(conceptSet.expression.items).map(item -> item.concept).allMatch(concept -> sourceConcepts.stream().anyMatch(Comparisons.compare(concept)));
            }
            return false;
        };
    }

    public static Predicate<Concept> compare(Concept source) {
        return concept -> new EqualsBuilder().append((Object)concept.conceptCode, (Object)source.conceptCode).append((Object)concept.domainId, (Object)source.domainId).append((Object)concept.vocabularyId, (Object)source.vocabularyId).build();
    }

    public static int compareTo(ObservationFilter filter, Window window) {
        int range1 = filter.postDays + filter.priorDays;
        int range2Start = 0;
        int range2End = 0;
        if (Objects.nonNull(window.start) && Objects.nonNull(window.start.days)) {
            range2Start = window.start.coeff * window.start.days;
        }
        if (Objects.nonNull(window.end) && Objects.nonNull(window.end.days)) {
            range2End = window.end.coeff * window.end.days;
        }
        return range1 - (range2End - range2Start);
    }

    public static boolean compare(Criteria c1, Criteria c2) {
        boolean result = false;
        if (Objects.equals(c1.getClass(), c2.getClass())) {
            if (c1 instanceof ConditionEra) {
                ConditionEra ce1 = (ConditionEra)c1;
                ConditionEra ce2 = (ConditionEra)c2;
                result = Objects.equals(ce1.codesetId, ce2.codesetId);
            } else if (c1 instanceof ConditionOccurrence) {
                ConditionOccurrence co1 = (ConditionOccurrence)c1;
                ConditionOccurrence co2 = (ConditionOccurrence)c2;
                result = Objects.equals(co1.codesetId, co2.codesetId);
            } else if (c1 instanceof Death) {
                Death d1 = (Death)c1;
                Death d2 = (Death)c2;
                result = Objects.equals(d1.codesetId, d2.codesetId);
            } else if (c1 instanceof DeviceExposure) {
                DeviceExposure de1 = (DeviceExposure)c1;
                DeviceExposure de2 = (DeviceExposure)c2;
                result = Objects.equals(de1.codesetId, de2.codesetId);
            } else if (c1 instanceof DoseEra) {
                DoseEra de1 = (DoseEra)c1;
                DoseEra de2 = (DoseEra)c2;
                result = Objects.equals(de1.codesetId, de2.codesetId);
            } else if (c1 instanceof DrugEra) {
                DrugEra de1 = (DrugEra)c1;
                DrugEra de2 = (DrugEra)c2;
                result = Objects.equals(de1.codesetId, de2.codesetId);
            } else if (c1 instanceof DrugExposure) {
                DrugExposure de1 = (DrugExposure)c1;
                DrugExposure de2 = (DrugExposure)c2;
                result = Objects.equals(de1.codesetId, de2.codesetId);
            } else if (c1 instanceof Measurement) {
                Measurement m1 = (Measurement)c1;
                Measurement m2 = (Measurement)c2;
                result = Objects.equals(m1.codesetId, m2.codesetId);
            } else if (c1 instanceof Observation) {
                Observation o1 = (Observation)c1;
                Observation o2 = (Observation)c2;
                result = Objects.equals(o1.codesetId, o2.codesetId);
            } else if (c1 instanceof ProcedureOccurrence) {
                ProcedureOccurrence po1 = (ProcedureOccurrence)c1;
                ProcedureOccurrence po2 = (ProcedureOccurrence)c2;
                result = Objects.equals(po1.codesetId, po2.codesetId);
            } else if (c1 instanceof Specimen) {
                Specimen s1 = (Specimen)c1;
                Specimen s2 = (Specimen)c2;
                result = Objects.equals(s1.codesetId, s2.codesetId);
            } else if (c1 instanceof VisitOccurrence) {
                VisitOccurrence vo1 = (VisitOccurrence)c1;
                VisitOccurrence vo2 = (VisitOccurrence)c2;
                result = Objects.equals(vo1.codesetId, vo2.codesetId);
            } else if (c1 instanceof VisitDetail) {
                VisitDetail vd1 = (VisitDetail)c1;
                VisitDetail vd2 = (VisitDetail)c2;
                result = Objects.equals(vd1.codesetId, vd2.codesetId);
            }
        }
        return result;
    }

    public static boolean isBefore(Window window) {
        return Objects.nonNull(window) && Comparisons.isBefore(window.start) && !Comparisons.isAfter(window.end);
    }

    public static boolean isBefore(Window.Endpoint endpoint) {
        return Objects.nonNull(endpoint) && endpoint.coeff < 0;
    }

    public static boolean isAfter(Window.Endpoint endpoint) {
        return Objects.nonNull(endpoint) && endpoint.coeff > 0;
    }
}

