/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.ArrayList;
import java.util.List;
import org.ohdsi.circe.check.Check;
import org.ohdsi.circe.check.Warning;
import org.ohdsi.circe.check.WarningSeverity;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.check.warnings.DefaultWarning;
import org.ohdsi.circe.cohortdefinition.CohortExpression;

public abstract class BaseCheck
implements Check {
    protected static final String INCLUSION_RULE = "inclusion rule ";
    protected static final String ADDITIONAL_RULE = "additional rule";
    protected static final String INITIAL_EVENT = "initial event";

    @Override
    public final List<Warning> check(CohortExpression expression) {
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        this.check(expression, this.defineReporter(warnings));
        return warnings;
    }

    protected WarningSeverity defineSeverity() {
        return WarningSeverity.CRITICAL;
    }

    protected WarningReporter defineReporter(List<Warning> warnings) {
        return this.getReporter(this.defineSeverity(), warnings);
    }

    protected abstract void check(CohortExpression var1, WarningReporter var2);

    protected WarningReporter getReporter(WarningSeverity severity, List<Warning> warnings) {
        return (template, params) -> warnings.add(new DefaultWarning(severity, String.format(template, params)));
    }
}

