/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.factor;

import org.eclipse.recommenders.internal.jayes.util.AddressCalc;
import org.eclipse.recommenders.jayes.factor.AbstractFactor;
import org.eclipse.recommenders.jayes.factor.arraywrapper.IArrayWrapper;
import org.eclipse.recommenders.jayes.util.MathUtils;

public class DenseFactor
extends AbstractFactor {
    @Override
    public void fill(double d) {
        this.values.fill(d);
    }

    @Override
    protected int getRealPosition(int virtualPosition) {
        return virtualPosition;
    }

    @Override
    public int[] prepareMultiplication(AbstractFactor compatible) {
        if (this.dimensions.length == 0) {
            return new int[1];
        }
        int[] positions = new int[this.values.length()];
        int[] counter = new int[this.dimensions.length];
        int[] localToForeignPosition = AddressCalc.computeLinearMap(compatible, this.dimensionIDs);
        counter[counter.length - 1] = -1;
        int i = 0;
        while (i < this.values.length()) {
            AddressCalc.incrementMultiDimensionalCounter(counter, this.dimensions);
            positions[i] = compatible.getRealPosition(MathUtils.scalarProduct(counter, localToForeignPosition));
            ++i;
        }
        return positions;
    }

    @Override
    public void copyValues(IArrayWrapper arrayWrapper) {
        this.validateCut();
        int index = this.cut.getStart();
        int length = Math.min(this.cut.getLength(), this.values.length() - index);
        this.values.arrayCopy(arrayWrapper, index, index, length);
    }

    @Override
    public int getOverhead() {
        return 0;
    }
}

