/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.hmc;

import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.hmc.HessianWrtParameterProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.math.MachineAccuracy;
import dr.xml.Reportable;

public class NumericalHessianFromGradient
implements HessianWrtParameterProvider,
Reportable {
    private final GradientWrtParameterProvider gradientProvider;

    public NumericalHessianFromGradient(GradientWrtParameterProvider gradientWrtParameterProvider) {
        this.gradientProvider = gradientWrtParameterProvider;
    }

    @Override
    public double[] getDiagonalHessianLogDensity() {
        int n = this.gradientProvider.getDimension();
        double[][] dArray = this.getNumericalHessianCentral();
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i][i];
        }
        return dArray2;
    }

    @Override
    public double[][] getHessianLogDensity() {
        return this.getNumericalHessianCentral();
    }

    @Override
    public Likelihood getLikelihood() {
        return this.gradientProvider.getLikelihood();
    }

    @Override
    public Parameter getParameter() {
        return this.gradientProvider.getParameter();
    }

    @Override
    public int getDimension() {
        return this.gradientProvider.getDimension();
    }

    @Override
    public double[] getGradientLogDensity() {
        return this.gradientProvider.getGradientLogDensity();
    }

    private double[][] getNumericalHessianCentral() {
        int n;
        int n2 = this.gradientProvider.getDimension();
        double[][] dArray = new double[n2][n2];
        double[] dArray2 = this.gradientProvider.getParameter().getParameterValues();
        double[][] dArray3 = new double[n2][n2];
        double[][] dArray4 = new double[n2][n2];
        double[] dArray5 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray5[n] = MachineAccuracy.SQRT_SQRT_EPSILON * (Math.abs(dArray2[n]) + 1.0);
            this.gradientProvider.getParameter().setParameterValue(n, dArray2[n] + dArray5[n]);
            dArray3[n] = this.gradientProvider.getGradientLogDensity();
            this.gradientProvider.getParameter().setParameterValue(n, dArray2[n] - dArray5[n]);
            dArray4[n] = this.gradientProvider.getGradientLogDensity();
            this.gradientProvider.getParameter().setParameterValue(n, dArray2[n]);
        }
        for (n = 0; n < n2; ++n) {
            for (int i = n; i < n2; ++i) {
                double d = (dArray3[i][n] - dArray4[i][n]) / (4.0 * dArray5[i]) + (dArray3[n][i] - dArray4[n][i]) / (4.0 * dArray5[n]);
                dArray[n][i] = d;
                dArray[i][n] = d;
            }
        }
        return dArray;
    }

    @Override
    public String getReport() {
        return GradientWrtParameterProvider.getReportAndCheckForError(this, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, GradientWrtParameterProvider.TOLERANCE);
    }
}

