/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.treedatalikelihood.LikelihoodTreeTraversal;
import dr.evomodel.treedatalikelihood.ProcessOnTreeDelegate;
import dr.evomodel.treedatalikelihood.ProcessSimulation;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.TreeTraversal;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.preorder.AbstractRealizedContinuousTraitDelegate;
import dr.evomodel.treedatalikelihood.preorder.MultivariateConditionalOnTipsRealizedDelegate;
import dr.evomodel.treedatalikelihood.preorder.ProcessSimulationDelegate;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.math.distributions.GaussianProcessRandomGenerator;
import java.util.List;

public class TreeTipGaussianProcess
implements GaussianProcessRandomGenerator,
Loggable {
    private final String traitName;
    private final ContinuousDataLikelihoodDelegate likelihoodDelegate;
    private final TreeDataLikelihood treeDataLikelihood;
    private final Tree tree;
    private final Parameter maskParameter;
    private final List<Integer> sampleIndices;
    private final int missingLength;
    private final int drawLength;
    private final boolean[] doSample;
    private final boolean[] doNotSample;
    private final TreeTrait tipSampleTrait;
    private final boolean truncateToMissingOnly;
    private final LikelihoodTreeTraversal treeTraversalDelegate;
    private double[] currentSample = null;

    public TreeTipGaussianProcess(String string, TreeDataLikelihood treeDataLikelihood, ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate, Parameter parameter, boolean bl) {
        Object object;
        Object object2;
        this.treeDataLikelihood = treeDataLikelihood;
        this.tree = treeDataLikelihood.getTree();
        this.maskParameter = parameter;
        List<Integer> list = continuousDataLikelihoodDelegate.getDataModel().getMissingIndices();
        if (list == null || list.size() == 0) {
            string = string + ".missing";
            continuousDataLikelihoodDelegate = ContinuousDataLikelihoodDelegate.createWithMissingData(continuousDataLikelihoodDelegate);
            object2 = new MultivariateConditionalOnTipsRealizedDelegate(string, treeDataLikelihood.getTree(), continuousDataLikelihoodDelegate.getDiffusionModel(), continuousDataLikelihoodDelegate.getDataModel(), continuousDataLikelihoodDelegate.getRootPrior(), continuousDataLikelihoodDelegate.getRateTransformation(), continuousDataLikelihoodDelegate);
            object = new ProcessSimulation(treeDataLikelihood, (ProcessSimulationDelegate)object2);
            treeDataLikelihood.addTraits(object.getTreeTraits());
            this.treeTraversalDelegate = new LikelihoodTreeTraversal(treeDataLikelihood.getTree(), treeDataLikelihood.getBranchRateModel(), TreeTraversal.TraversalType.POST_ORDER);
        } else {
            this.treeTraversalDelegate = null;
        }
        this.likelihoodDelegate = continuousDataLikelihoodDelegate;
        this.sampleIndices = continuousDataLikelihoodDelegate.getDataModel().getMissingIndices();
        this.missingLength = this.sampleIndices.size();
        this.traitName = string;
        object2 = AbstractRealizedContinuousTraitDelegate.getTipTraitName(string);
        this.tipSampleTrait = treeDataLikelihood.getTreeTrait((String)object2);
        assert (this.tipSampleTrait != null);
        object = this.drawAllTraits();
        this.drawLength = ((Object)object).length;
        this.doSample = new boolean[this.drawLength];
        for (int n : this.sampleIndices) {
            this.doSample[n] = true;
        }
        this.doNotSample = new boolean[this.drawLength];
        for (int i = 0; i < this.drawLength; ++i) {
            this.doNotSample[i] = !this.doSample[i];
        }
        this.truncateToMissingOnly = bl;
    }

    private double[] drawAllTraits() {
        this.doPostOrderTraversal();
        return (double[])this.tipSampleTrait.getTrait(this.treeDataLikelihood.getTree(), null);
    }

    private double[] drawSelectedTraits() {
        double[] dArray = this.drawAllTraits();
        if (this.truncateToMissingOnly) {
            dArray = this.maskDraw(dArray, this.doSample);
        }
        return dArray;
    }

    private void doPostOrderTraversal() {
        if (this.treeTraversalDelegate != null) {
            this.treeTraversalDelegate.updateAllNodes();
            this.treeTraversalDelegate.dispatchTreeTraversalCollectBranchAndNodeOperations();
            List<ProcessOnTreeDelegate.BranchOperation> list = this.treeTraversalDelegate.getBranchOperations();
            List<ProcessOnTreeDelegate.NodeOperation> list2 = this.treeTraversalDelegate.getNodeOperations();
            NodeRef nodeRef = this.treeDataLikelihood.getTree().getRoot();
            this.likelihoodDelegate.calculateLikelihood(list, list2, nodeRef.getNumber());
        } else {
            this.treeDataLikelihood.fireModelChanged();
        }
    }

    private double[] maskDraw(double[] dArray, boolean[] blArray) {
        double[] dArray2 = new double[this.missingLength];
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!blArray[i]) continue;
            dArray2[n] = dArray[i];
            ++n;
        }
        return dArray2;
    }

    @Override
    public Likelihood getLikelihood() {
        return this.treeDataLikelihood;
    }

    @Override
    public int getDimension() {
        return this.truncateToMissingOnly ? this.missingLength : this.drawLength;
    }

    @Override
    public double[][] getPrecisionMatrix() {
        throw new RuntimeException("Precision matrix is never formed");
    }

    @Override
    public Object nextRandom() {
        return this.drawSelectedTraits();
    }

    @Override
    public double logPdf(Object object) {
        throw new RuntimeException("Density is never evaluated");
    }

    @Override
    public LogColumn[] getColumns() {
        double[] dArray = this.drawSelectedTraits();
        LogColumn[] logColumnArray = new LogColumn[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            logColumnArray[i] = new TipSampleColumn("tip", i);
        }
        return logColumnArray;
    }

    static /* synthetic */ double[] access$002(TreeTipGaussianProcess treeTipGaussianProcess, double[] dArray) {
        treeTipGaussianProcess.currentSample = dArray;
        return dArray;
    }

    private class TipSampleColumn
    extends NumberColumn {
        private int index;

        TipSampleColumn(String string, int n) {
            super(string);
            this.index = n;
        }

        @Override
        public double getDoubleValue() {
            if (this.index == 0) {
                TreeTipGaussianProcess.access$002(TreeTipGaussianProcess.this, TreeTipGaussianProcess.this.drawSelectedTraits());
            }
            return TreeTipGaussianProcess.this.currentSample[this.index];
        }
    }
}

