
library(ALS)
library(TIMP)

x2 <- 50:449  

x <-  5720:5800

Cmodel <- mass()
Cmodel@x <- x 
Cmodel@nt <- length(x)
Cmodel@extracomp <- FALSE

Cparam <- theta()

snr <- 1000

abvar <- c(0.01,.05,.1,.25,.5,1,2,3,4,5,6)


S <- as.matrix(read.table("S.R"))
S[,1]<-S[,1]*2

set.seed(10)

pdf("Celvar_color.pdf", width=7,height=14)

par(mfrow=c(length(abvar),2),mar=c(0,0,0,0),oma=c(2,1,1,1),cex=2)

colr <- c(rgb(1,0,0,.25),rgb(0,0,1,.25))

for(j in 1:length(abvar)) {
  
  Cparam@peakpar <- list(c(5755-abvar[j],7,1),c(5755,7,1)) 
  
  Cparam@amplitudes <- a1 <- c(1,2)
  C1 <- compModelMass(Cparam, Cmodel)
  
  Cparam@amplitudes <- a2 <- c(1.5,2)

  C2 <- compModelMass(Cparam, Cmodel)
    
 
  matplot(x,C1,type="l", xaxt="n", yaxt="n", lty=1, ylim=c(0, max(C1)),
          col=colr)
  polygon(x,C1[,1],col=colr[1])
  polygon(x,C1[,2],col= colr[2])

  if(j==length(abvar))
    axis(1,at=c(5740,5760,5780))
    
  matplot(x,C2,type="l", xaxt="n", yaxt="n", lty=1, ylim=c(0, max(C2)),
          col=colr)
  polygon(x,C2[,1],col=colr[1])
  polygon(x,C2[,2],col= colr[2])

  if(j==length(abvar))
    axis(1,at=c(5740,5760,5780))
   
}

dev.off()
